/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.Map;
import java.util.Calendar;
import org.opengion.hayabusa.develop.AbstractJspCreate;
import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGAttributes;

/**
 * 
 * @author Administrator
 *
 */
public class JspCreate_OG_COMMENT extends AbstractJspCreate {
	private List<JspConvertEntity> COMMENT_ROWS ;
	private boolean IS_NULL ;

	/**
	 * 初期化メソッド
	 * 
	 * 内部で使用する JspConvertEntity の List のマップを受け取り、初期化を行います。
	 * 
	 * @param master Map<String,List<JspConvertEntity>>
	 */
	@Override
	protected void init( Map<String,List<JspConvertEntity>> master ) {
		COMMENT_ROWS = master.get("COMMENT");
		IS_NULL = (COMMENT_ROWS == null || COMMENT_ROWS.isEmpty() );
		KEY = "og:comment";
	}

	/**
	 * ファイル名から、処理対象かどうかを判断します。
	 * 
	 * @param  name String 処理対象のファイル名
	 * @return boolean 処理対象なら true/ そうでなければ、false
	 */
	@Override
	protected boolean isExecute( final String name ) {
		return ( name != null && name.indexOf( "index" ) < 0 && name.indexOf( "forward" ) < 0 );
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 * 
	 * @param attr OGAttributes エレメントの属性オブジェクト
	 * @return String 変換された文字列
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGAttributes attr )  throws Throwable {
		if( IS_NULL ) { return ""; }

		JspConvertEntity ENTITY = COMMENT_ROWS.get(0);

		// TODO Auto-generated method stub
		//書き出す文字列を作成開始。
		StringBuilder sbTub = new StringBuilder();
		sbTub.append( "<og:comment").append( CR );
		sbTub.append( "\tsystem  = \""	).append( ENTITY.getNmSys()	).append( "\"" ).append( CR );
		sbTub.append( "\tpgid    = \""	).append( ENTITY.getPgid()	).append( "\"" ).append( CR );
		sbTub.append( "\ttitle   = \""	).append( ENTITY.getNmpg()	).append( "\"" ).append( CR );
		sbTub.append( "\tdate    = \""	).append( toDay()			).append( "\"" ).append( CR );
		sbTub.append( "\tauthor  = \""	).append( "Auto Create"		).append( "\"" ).append( CR );
		sbTub.append( "\ttext    = \""	).append( ""				).append( "\"" ).append( CR );
		sbTub.append( "\tversion = \""	).append( "001"				).append( "\"" ).append( CR );
		sbTub.append( "/>" ).append( CR );
		return sbTub.toString();
	}

	/**
	 * 現在の日付（yyyy/mm/dd）を取得。
	 * 
	 * @return 現在の日付
	 */
	private String toDay(){
		 //インスタンス化
		 Calendar now = Calendar.getInstance(); 
		
		int year = now.get(Calendar.YEAR);
		int mm   = now.get(Calendar.MONTH) + 1;
		int dd   = now.get(Calendar.DATE);

		String month = String.valueOf( mm );
		if (mm < 10){
			month = "0" + month ;
		}
		String day = String.valueOf( dd );
		if (dd < 10){
			day = "0" + day ;
		}
		return year + "/" + month + "/" + day;
	}
}
