/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.Map;

import org.opengion.hayabusa.develop.AbstractJspCreate;
import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGAttributes;

/**
 * query.jspの&ltog:select&gtタグを作成します。<br />
 * 
 * ●使用例<br />
 * 		JspConvertEntity e = new JspConvertEntity();<br />
 * 		e.setTableName("GF92");<br />
 * 		e.setColumnName("CLM");<br />
 * 		List< JspConvertEntity> a = new List< JspConvertEntity>();<br />
 * 		a.add( e );<br />
 * 		Map< String , List< JspConvertEntity> > m = new Map< String , List<JspConvertEntity> >();<br />
 * 		m.put( "ORDER", a );<br />
 * 		JspCreate  j = JspCreateFactory.newInstance( "OG_SELECT",m );<br />
 * 		j.execute("&ltog:select /&gt");
 * 
 * @author Takeshi.Takada
 *
 */
public class JspCreate_OG_SELECT extends AbstractJspCreate {
	private List<JspConvertEntity> ORDER_ROWS ;
	private boolean IS_NULL ;

	/**
	 * 初期化メソッド
	 * 
	 * 内部で使用する JspConvertEntity の List のマップを受け取り、初期化を行います。
	 * 
	 * @param master Map<String,List<JspConvertEntity>>
	 */
	protected void init( Map<String,List<JspConvertEntity>> master ) {
		ORDER_ROWS = master.get("ORDER");
		IS_NULL = (ORDER_ROWS == null || ORDER_ROWS.isEmpty() );
		KEY  = "og:select";
		NAME = "query";
	} 

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 * 
	 * @param attr OGAttributes エレメントの属性オブジェクト
	 * @return String 変換された文字列
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGAttributes attr )  throws Throwable {
		if( IS_NULL ) { return ""; }

		// TODO Auto-generated method stub
		//書き出す文字列を作成開始。
		StringBuilder sbTub = new StringBuilder();

		//JOIN情報から<og:select>タグの検索句を生成する準備をします。
		sbTub.append( "\t\t<og:select name=\"ORDER_BY\" lbl=\"ORDER_BY\">").append( CR );
		boolean isFirst = true;

		for ( JspConvertEntity column : ORDER_ROWS ){
			sbTub.append( "\t\t\t<og:option value=\"" );
			sbTub.append( column.getRemarks() );
			sbTub.append( "\"\t\t" );
			sbTub.append( " lbls=\"");
			sbTub.append( column.getRemarks() );
			sbTub.append( "\" ");
			if ( isFirst ){
				sbTub.append( "selected=\"selected\"");
				isFirst = false;
			}
			sbTub.append( " />" ).append( CR );
		}
		sbTub.append( "\t\t</og:select>").append( CR );

		return sbTub.toString();
	}

}
