/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.opengion.fukurou.util.HybsLoaderConfig;

public class HybsLoader {
    private static final String CR = System.getProperty("line.separator");
    private static final String CONST_LOADER_KEY = "CONST_LOADER_KEY";
    private static final JavaCompiler COMPILER = ToolProvider.getSystemJavaCompiler();
    private static final StandardJavaFileManager FILE_MANAGER = COMPILER.getStandardFileManager(null, null, null);
    private final Map<String, HybsURLClassLoader> loaderMap = new WeakHashMap<String, HybsURLClassLoader>();
    private final Map<String, String> clsNameMap = new WeakHashMap<String, String>();
    private final String srcDir;
    private final String classDir;
    private final boolean isHotDeploy;
    private final boolean isAutoCompile;
    private final String classPath;

    public HybsLoader(HybsLoaderConfig hybsLoaderConfig) {
        this.srcDir = hybsLoaderConfig.getSrcDir();
        this.classDir = hybsLoaderConfig.getClassDir();
        this.isHotDeploy = hybsLoaderConfig.isHotDeploy();
        this.isAutoCompile = hybsLoaderConfig.isAutoCompile();
        this.classPath = hybsLoaderConfig.getClassPath();
    }

    public Class<?> load(String string) {
        String string2 = this.getQualifiedName(string);
        if (this.isAutoCompile) {
            this.compileClass(string2);
        }
        Class<?> clazz = this.loadClass(string2);
        return clazz;
    }

    public Object newInstance(String string) {
        Class<?> clazz = this.load(string);
        Object var3_3 = null;
        try {
            var3_3 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string2 = "\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]";
            throw new RuntimeException(string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string3 = "\u30a2\u30af\u30bb\u30b9\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002[" + string + "]";
            throw new RuntimeException(string3, illegalAccessException);
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQualifiedName(String string) {
        String string2 = null;
        if (string.indexOf(46) >= 0) {
            string2 = string;
        } else {
            Map<String, String> map = this.clsNameMap;
            synchronized (map) {
                string2 = this.clsNameMap.get(string);
                if (string2 == null) {
                    string2 = this.findFile("", string);
                }
                this.clsNameMap.put(string, string2);
            }
            if (string2 == null) {
                throw new RuntimeException("\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb=[" + string + "]");
            }
        }
        return string2;
    }

    private String findFile(String string, String string2) {
        String string3 = this.srcDir + string;
        File[] fileArray = new File(string3).listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    String string4 = this.findFile(string + fileArray[i].getName() + File.separator, string2);
                    if (string4 == null || string4.length() <= 0) continue;
                    return string4;
                }
                if (!(string2 + ".java").equals(fileArray[i].getName())) continue;
                return string.replace(File.separatorChar, '.') + string2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileClass(String string) {
        if (COMPILER == null) {
            throw new RuntimeException("\u30b3\u30f3\u30d1\u30a4\u30e9\u30af\u30e9\u30b9\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002tools.jar\u304c\u5b58\u5728\u3057\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
        }
        String string2 = this.srcDir + string.replace(".", File.separator) + ".java";
        File file = new File(string2);
        if (!file.exists()) {
            throw new RuntimeException("\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb=[" + string2 + "]");
        }
        String string3 = this.classDir + string.replace(".", File.separator) + ".class";
        File file2 = new File(string3);
        if (file2.exists() && file.lastModified() <= file2.lastModified()) {
            return;
        }
        if (!file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            throw new RuntimeException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb=[" + file2 + "]");
        }
        StringWriter stringWriter = new StringWriter();
        File[] fileArray = new File[]{new File(string2)};
        String[] stringArray = new String[]{"-d", this.classDir, "-classpath", this.classPath, "-encoding", "UTF-8"};
        JavaCompiler.CompilationTask compilationTask = COMPILER.getTask(stringWriter, FILE_MANAGER, null, Arrays.asList(stringArray), null, FILE_MANAGER.getJavaFileObjects(fileArray));
        boolean bl = false;
        HybsLoader hybsLoader = this;
        synchronized (hybsLoader) {
            bl = compilationTask.call();
        }
        if (!bl) {
            throw new RuntimeException("\u30b3\u30f3\u30d1\u30a4\u30eb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CR + stringWriter.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(String string) {
        String string2 = this.isHotDeploy ? string : CONST_LOADER_KEY;
        String string3 = this.classDir + string.replace(".", File.separator) + ".class";
        File file = new File(string3);
        if (!file.exists()) {
            throw new RuntimeException("\u30af\u30e9\u30b9\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb=[" + string3 + "]");
        }
        long l = file.lastModified();
        HybsURLClassLoader hybsURLClassLoader = null;
        Object object = this.loaderMap;
        synchronized (object) {
            hybsURLClassLoader = this.loaderMap.get(string2);
            if (hybsURLClassLoader == null || l > hybsURLClassLoader.getCreationTime()) {
                try {
                    hybsURLClassLoader = new HybsURLClassLoader(new URL[]{new File(this.classDir).toURI().toURL()}, this.getClass().getClassLoader());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("\u30af\u30e9\u30b9\u30ed\u30fc\u30c9\u306eURL\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30d5\u30a1\u30a4\u30eb=[" + string3 + "]", malformedURLException);
                }
                this.loaderMap.put(string2, hybsURLClassLoader);
            }
        }
        try {
            object = hybsURLClassLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string4 = "\u30af\u30e9\u30b9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb=[" + string3 + "]";
            throw new RuntimeException(string4, classNotFoundException);
        }
        return object;
    }

    private static class HybsURLClassLoader {
        final URLClassLoader loader;
        final long creationTime;

        HybsURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            this.loader = new URLClassLoader(uRLArray, classLoader);
            this.creationTime = System.currentTimeMillis();
        }

        HybsURLClassLoader(URL[] uRLArray) {
            this(uRLArray, null);
        }

        Class<?> loadClass(String string) throws ClassNotFoundException {
            return this.loader.loadClass(string);
        }

        long getCreationTime() {
            return this.creationTime;
        }
    }
}

