/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class DisplayCapture
implements FlavorListener {
    private static final Clipboard CLIP_BOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private static final Rectangle SCRN_SIZE = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    private File baseDir = new File(".");
    private String firstID = "seq";
    private String imgType = "png";
    private int cnt = 100;

    public void setBaseDir(String string) {
        if (string != null && string.length() > 0) {
            this.baseDir = new File(string);
            if (!this.baseDir.exists() && !this.baseDir.mkdirs()) {
                String string2 = "ERROR:\u30bb\u30fc\u30d6\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + this.baseDir.getAbsolutePath();
                throw new RuntimeException(string2);
            }
        }
    }

    public void setFirstID(String string) {
        if (string != null) {
            if (string.matches("seq|gui")) {
                this.firstID = string;
            } else {
                String string2 = "ERROR:firstID \u5c5e\u6027\u306f\u3001(seq|gui)\u3067\u304a\u9858\u3044\u3057\u307e\u3059\u3002firstID=[" + string + "]";
                throw new RuntimeException(string2);
            }
        }
    }

    public void setImageType(String string) {
        if (string != null && string.matches("png|gif|jpg")) {
            this.imgType = string;
        }
    }

    public void setStartCnt(String string) {
        if (string != null && string.length() > 0) {
            this.cnt = Integer.parseInt(string);
        }
    }

    public static BufferedImage doCapture() {
        BufferedImage bufferedImage = null;
        try {
            Robot robot = new Robot();
            bufferedImage = robot.createScreenCapture(SCRN_SIZE);
        }
        catch (AWTException aWTException) {
            String string = "ERROR:\u753b\u50cf\u30a4\u30e1\u30fc\u30b8(\u30ad\u30e3\u30d7\u30c1\u30e3\u753b\u50cf)\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            DisplayCapture.setClipboard(string);
            throw new RuntimeException(string, aWTException);
        }
        catch (Throwable throwable) {
            String string = "ERROR:" + throwable.getLocalizedMessage();
            DisplayCapture.setClipboard(string);
            throw new RuntimeException(string, throwable);
        }
        return bufferedImage;
    }

    public static void saveImage(BufferedImage bufferedImage, String string, File file) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, file);
        }
        catch (IOException iOException) {
            String string2 = "ERROR:\u30ad\u30e3\u30d7\u30c1\u30e3\u753b\u50cf\u3092\u30d5\u30a1\u30a4\u30eb\u306b\u30bb\u30fc\u30d6\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + file.getAbsolutePath();
            DisplayCapture.setClipboard(string2);
            throw new RuntimeException(string2, iOException);
        }
        catch (Throwable throwable) {
            String string3 = "ERROR:" + throwable.getLocalizedMessage();
            DisplayCapture.setClipboard(string3);
            throw new RuntimeException(string3, throwable);
        }
    }

    public static String getClipboard() {
        String string = null;
        try {
            string = (String)CLIP_BOARD.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            string = "GUI:PRINT SCREEN.img";
        }
        catch (IOException iOException) {
            String string2 = "ERROR:\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306e\u5024\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            DisplayCapture.setClipboard(string2);
            throw new RuntimeException(string2, iOException);
        }
        catch (Throwable throwable) {
            String string3 = "ERROR:" + throwable.getLocalizedMessage();
            DisplayCapture.setClipboard(string3);
            throw new RuntimeException(string3, throwable);
        }
        return string;
    }

    public static void setClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        CLIP_BOARD.setContents(stringSelection, null);
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        String string = DisplayCapture.getClipboard();
        if (string != null && string.length() > 0 && string.startsWith("GUI:")) {
            System.out.println(this.cnt + ":\u3010" + string + "\u3011");
            BufferedImage bufferedImage = DisplayCapture.doCapture();
            File file = this.makeSaveFile(string);
            DisplayCapture.saveImage(bufferedImage, this.imgType, file);
            DisplayCapture.setClipboard(string.substring(4));
        }
    }

    private File makeSaveFile(String string) {
        int n = string.indexOf(32);
        String string2 = string.substring(4, n);
        String string3 = string.substring(n + 1, string.length() - 4);
        String string4 = null;
        if ("seq".equalsIgnoreCase(this.firstID)) {
            string4 = this.cnt++ + "_" + string2 + "_" + string3 + "." + this.imgType;
        } else if ("gui".equalsIgnoreCase(this.firstID)) {
            string4 = string2 + "_" + string3 + "_" + this.cnt++ + "." + this.imgType;
        }
        File file = new File(this.baseDir, string4);
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            String string5 = "ERROR:\u30bb\u30fc\u30d6\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + file2.getAbsolutePath();
            DisplayCapture.setClipboard(string5);
            throw new RuntimeException(string5);
        }
        if (file.exists()) {
            String string6 = "ERROR:\u30bb\u30fc\u30d6\u30d5\u30a1\u30a4\u30eb\u304c\u3059\u3067\u306b\u4f5c\u6210\u3055\u308c\u3066\u3044\u307e\u3059\u3002" + file.getAbsolutePath();
            DisplayCapture.setClipboard(string6);
            throw new RuntimeException(string6);
        }
        return file;
    }

    public static void main(String[] stringArray) {
        System.out.println("DisplayCapture \u3092\u8d77\u52d5\u3057\u307e\u3057\u305f\u3002");
        DisplayCapture displayCapture = new DisplayCapture();
        if (stringArray.length > 0) {
            displayCapture.setBaseDir(stringArray[0]);
        }
        if (stringArray.length > 1) {
            displayCapture.setFirstID(stringArray[1]);
        }
        if (stringArray.length > 2) {
            displayCapture.setImageType(stringArray[2]);
        }
        if (stringArray.length > 3) {
            displayCapture.setStartCnt(stringArray[3]);
        }
        DisplayCapture.setClipboard(null);
        CLIP_BOARD.addFlavorListener(displayCapture);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(100000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

