/**************************************************************************/
/* GE12 ( システムパラメータ定義 )                                        */
/*                                                                        */
/* Created : 2010/10/02 08:11:28                                          */
/**************************************************************************/
CREATE TABLE GE12 (
   SYSTEM_ID   VARCHAR2(10)                   NOT NULL      /* 10  システムID       */
 , PARAM_ID    VARCHAR2(50)                   NOT NULL      /* 20  パラメータID     */
 , SEQNO       NUMBER(7)         DEFAULT 0    NOT NULL      /* 30  表示順           */
 , TITLE       VARCHAR2(300)                                /* 40  タイトル         */
 , PARAM       VARCHAR2(500)                                /* 50  設定値           */
 , CONTENTS    VARCHAR2(4000)                               /* 60  内容             */
 , PARAM_LVL   VARCHAR2(1)       DEFAULT '5'  NOT NULL      /* 70  設定レベル       */
 , KBSAKU      VARCHAR2(1)       DEFAULT '1'  NOT NULL      /* 80  作成区分         */
 , FGCRYPT     VARCHAR2(1)       DEFAULT '0'  NOT NULL      /* 90  要再起動フラグ   */
 , CONTXT_PATH VARCHAR2(50)      DEFAULT '**' NOT NULL      /* 100 コンテキストパス */
 , FGREBOOT    VARCHAR2(1)       DEFAULT '0'                /* 110 要再起動フラグ   */
 , UNIQ        NUMBER(9)         DEFAULT 0    NOT NULL      /* 120 ユニークキー     */
 , FGJ         VARCHAR2(1)       DEFAULT '1'  NOT NULL      /* 130 状態フラグ       */
 , DYSET       VARCHAR2(14)                                 /* 140 登録日時         */
 , PGSET       VARCHAR2(10)                                 /* 150 作成PG           */
 , PGPSET      VARCHAR2(10)                                 /* 160 作成親PG         */
 , USRSET      VARCHAR2(10)                                 /* 170 作成社員         */
 , DYUPD       VARCHAR2(14)                                 /* 180 更新日時         */
 , PGUPD       VARCHAR2(10)                                 /* 190 更新PG           */
 , PGPUPD      VARCHAR2(10)                                 /* 200 更新親PG         */
 , USRUPD      VARCHAR2(10)                                 /* 210 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 448K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE12S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE12T00 
BEFORE INSERT ON GE12
FOR EACH ROW 
BEGIN 
SELECT GE12S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

