/**************************************************************************/
/* GF73 ( 使用カラム状態テーブル )                                        */
/*                                                                        */
/* Created : 2010/10/02 08:11:29                                          */
/**************************************************************************/
CREATE TABLE GF73 (
   SYSTEM_ID   VARCHAR2(10)                  NOT NULL      /* 10  システムID     */
 , ADDRESS     VARCHAR2(256)                               /* 20  アドレス       */
 , PRE_FIX     VARCHAR2(10)                  NOT NULL      /* 30  名前空間       */
 , FILENAME    VARCHAR2(60)                                /* 40  ファイル名     */
 , FILEPATH    VARCHAR2(256)                               /* 50  ファイルパス   */
 , MODIFIED    VARCHAR2(14)                                /* 60  最終更新日     */
 , TAGNAME     VARCHAR2(30)                                /* 70  タグ名称       */
 , FORM_TYPE   VARCHAR2(10)                                /* 80  フォームタイプ */
 , FORM_NAME   VARCHAR2(200)                               /* 90  名称           */
 , FORM_VAL    VARCHAR2(1000)                              /* 100 値             */
 , DEFAULT_VAL VARCHAR2(100)                               /* 110 デフォルト値   */
 , LBLCD       VARCHAR2(60)                                /* 120 ラベルコード   */
 , MSGCD       VARCHAR2(20)                                /* 130 メッセージID   */
 , MUST        VARCHAR2(10)                                /* 140 必須           */
 , VIEW_SIZE   VARCHAR2(20)                                /* 150 表示桁数       */
 , MAX_SIZE    VARCHAR2(20)                                /* 160 最大使用桁数   */
 , CODE_CLM    VARCHAR2(30)                                /* 170 コードカラム   */
 , READONLY    VARCHAR2(20)                                /* 180 読取専用       */
 , DISABLED    VARCHAR2(20)                                /* 190 無効           */
 , ROLES       VARCHAR2(500)                               /* 200 ロールズ       */
 , TEXT_DATA   CLOB                                        /* 210 テキスト       */
 , FGOMIT      VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 220 除外フラグ     */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 230 ユニークキー   */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 240 状態フラグ     */
 , DYSET       VARCHAR2(14)                                /* 250 登録日時       */
 , PGSET       VARCHAR2(10)                                /* 260 作成PG         */
 , PGPSET      VARCHAR2(10)                                /* 270 作成親PG       */
 , USRSET      VARCHAR2(10)                                /* 280 作成社員       */
 , DYUPD       VARCHAR2(14)                                /* 290 更新日時       */
 , PGUPD       VARCHAR2(10)                                /* 300 更新PG         */
 , PGPUPD      VARCHAR2(10)                                /* 310 更新親PG       */
 , USRUPD      VARCHAR2(10)                                /* 320 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 2048K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF73S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF73T00 
BEFORE INSERT ON GF73
FOR EACH ROW 
BEGIN 
SELECT GF73S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

