/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.Color;
import java.awt.Paint;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.ChartFactory;
import org.opengion.hayabusa.io.HybsDrawItem;
import org.opengion.hayabusa.io.HybsLineRenderer;
import org.opengion.hayabusa.io.HybsNumberAxis;
import org.opengion.hayabusa.io.HybsStackedBarRenderer;
import org.opengion.hayabusa.io.ShapeList;
import org.opengion.hayabusa.io.TypeRenderer;
import org.opengion.hayabusa.io.ValueMarkOverColors;

public class ChartDataset {
    private Dataset dataset = null;
    private String query = null;
    private String chartType = null;
    private boolean baseLegend = true;
    private String valueLabel = null;
    private double[] markValues = null;
    private Color[] markColors = new Color[]{Color.RED};
    private Color[] markOverColors = null;
    private boolean useMarkAnchor = true;
    private int dynamicOCNo = -1;
    private int dynamicOCadrs = -1;
    private String lowerBound = null;
    private String upperBound = null;
    private String tickSize = null;
    private boolean useGradient = false;
    private boolean shapesVisible = true;
    private Color[] shapeColors = null;
    private String shapeScale = null;
    private boolean useDottedLine = false;
    private Color[] seriesColors = null;
    private boolean isLabelsVisible = true;
    private boolean isMarksVisible = true;
    private boolean isItemValVisible = false;
    private boolean isItemLastVisible = false;
    private boolean useItemLabelSep = true;
    private String barWidth = null;
    private String maxBarWidth = null;
    private String itemMargin = null;
    private String visibleLimit = null;
    private String valueInset = null;
    private double domainMargin = 0.0;

    public void makeDataset(Connection connection, String string) throws SQLException {
        this.dataset = ChartFactory.newDataset(connection, string, this.chartType);
        this.query = string;
        if (this.dataset instanceof DefaultValueDataset) {
            if (this.markValues != null && this.markValues.length > 0) {
                ((DefaultValueDataset)this.dataset).setValue((Number)this.markValues[0]);
            } else {
                String string2 = "markValues \u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
                throw new HybsSystemException(string2);
            }
        }
    }

    protected NumberAxis makeNumberAxis() {
        HybsNumberAxis hybsNumberAxis = new HybsNumberAxis(this.valueLabel);
        if (this.lowerBound != null) {
            hybsNumberAxis.setLowerBound(Double.parseDouble(this.lowerBound));
        }
        if (this.upperBound != null) {
            hybsNumberAxis.setUpperBound(Double.parseDouble(this.upperBound));
        }
        if (this.tickSize != null) {
            hybsNumberAxis.setTickUnit(new NumberTickUnit(Double.parseDouble(this.tickSize)));
        }
        hybsNumberAxis.setTickLabelsVisible(this.isLabelsVisible);
        hybsNumberAxis.setTickMarksVisible(this.isMarksVisible);
        hybsNumberAxis.setAxisLineVisible(this.isMarksVisible);
        if (this.valueInset != null) {
            double d = Double.parseDouble(this.valueInset);
            RectangleInsets rectangleInsets = hybsNumberAxis.getTickLabelInsets();
            RectangleInsets rectangleInsets2 = new RectangleInsets(rectangleInsets.getUnitType(), rectangleInsets.getTop(), rectangleInsets.getLeft(), rectangleInsets.getBottom(), rectangleInsets.getRight() + d);
            hybsNumberAxis.setTickLabelInsets(rectangleInsets2);
        }
        return hybsNumberAxis;
    }

    public String getQuery() {
        return this.query;
    }

    protected Dataset getDataset() {
        return this.dataset;
    }

    public void setChartType(String string) {
        if (string != null && string.length() > 0) {
            this.chartType = string;
        }
    }

    protected String getChartType() {
        return this.chartType;
    }

    public void setBaseLegend(boolean bl) {
        this.baseLegend = bl;
    }

    protected CategoryItemRenderer getRenderer(int n, CategoryURLGenerator categoryURLGenerator) {
        ShapeList shapeList;
        Object object;
        TypeRenderer typeRenderer = ChartFactory.getTypeRenderer(this.chartType);
        CategoryItemRenderer categoryItemRenderer = (CategoryItemRenderer)typeRenderer.getRenderer();
        if (categoryItemRenderer instanceof LineAndShapeRenderer) {
            object = (LineAndShapeRenderer)categoryItemRenderer;
            object.setBaseShapesVisible(this.shapesVisible);
            if (n >= 0) {
                object.setSeriesShapesVisible(n, true);
            }
            shapeList = new ShapeList();
            for (int i = 0; i < shapeList.size(); ++i) {
                object.setSeriesShape(i, shapeList.getShape(i));
            }
        }
        if (categoryItemRenderer instanceof HybsLineRenderer) {
            object = (HybsLineRenderer)categoryItemRenderer;
            if (this.shapeColors != null) {
                ((HybsLineRenderer)object).setShapeColors(this.shapeColors);
            }
            ((HybsLineRenderer)object).setShapeScale(this.shapeScale);
            if (this.markOverColors != null) {
                ((HybsLineRenderer)object).setValueMarkOverColors(this.getValueMarkOverColors(), this.dynamicOCNo);
            }
            if (this.visibleLimit != null) {
                ((HybsLineRenderer)object).setVisibleLimit(Double.valueOf(this.visibleLimit));
            }
        }
        if (categoryItemRenderer instanceof BarRenderer) {
            object = (BarRenderer)categoryItemRenderer;
            if (this.itemMargin != null) {
                double d = Double.parseDouble(this.itemMargin);
                object.setItemMargin(d);
            }
            if (this.maxBarWidth != null) {
                object.setMaximumBarWidth(Double.parseDouble(this.maxBarWidth));
            }
        }
        if (categoryItemRenderer instanceof HybsStackedBarRenderer) {
            object = (HybsStackedBarRenderer)categoryItemRenderer;
            ((HybsStackedBarRenderer)((Object)object)).setDomainMargin(this.domainMargin);
        }
        categoryItemRenderer.setBaseSeriesVisibleInLegend(this.baseLegend);
        if (this.isItemValVisible) {
            object = NumberFormat.getInstance();
            ((NumberFormat)object).setGroupingUsed(this.useItemLabelSep);
            shapeList = new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)object);
            categoryItemRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)shapeList);
            if (n >= 0) {
                categoryItemRenderer.setSeriesItemLabelsVisible(n, true);
            } else {
                categoryItemRenderer.setBaseItemLabelsVisible(true);
            }
            if (this.dynamicOCNo >= 0) {
                categoryItemRenderer.setSeriesItemLabelsVisible(this.dynamicOCNo, false);
            }
            if (this.isItemLastVisible && categoryItemRenderer instanceof HybsDrawItem) {
                ((HybsDrawItem)categoryItemRenderer).setItemLabelLastVisible(true);
            }
        }
        if (categoryURLGenerator != null) {
            if (n >= 0) {
                categoryItemRenderer.setSeriesItemURLGenerator(n, categoryURLGenerator);
            } else {
                categoryItemRenderer.setBaseItemURLGenerator(categoryURLGenerator);
            }
        }
        return categoryItemRenderer;
    }

    public void setValueLabel(String string) {
        if (string != null && string.length() > 0) {
            this.valueLabel = string;
        }
    }

    protected String getValueLabel() {
        return this.valueLabel;
    }

    public void setMarkValues(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.markValues = new double[n];
            for (int i = 0; i < n; ++i) {
                if ("G".equals(stringArray[i])) {
                    this.dynamicOCadrs = i;
                    this.markValues[i] = 0.0;
                    continue;
                }
                this.markValues[i] = Double.parseDouble(stringArray[i]);
            }
        }
    }

    public void setMarkColors(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.markColors = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.markColors[i] = StringUtil.getColorInstance((String)stringArray[i]);
            }
        }
    }

    public void setUseMarkAnchor(boolean bl) {
        this.useMarkAnchor = bl;
    }

    public void setMarkOverColors(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.markOverColors = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.markOverColors[i] = StringUtil.getColorInstance((String)stringArray[i]);
            }
        }
    }

    private ValueMarkOverColors getValueMarkOverColors() {
        ValueMarkOverColors valueMarkOverColors = null;
        if (this.markValues != null && this.markOverColors != null && this.markValues.length + 1 == this.markOverColors.length && this.markValues.length >= 1) {
            int n = this.dynamicOCadrs >= 0 ? this.dynamicOCadrs : 0;
            valueMarkOverColors = new ValueMarkOverColors(this.markValues, this.markOverColors, this.markColors[n], this.dynamicOCadrs);
        }
        return valueMarkOverColors;
    }

    public void setDynamicOCNo(int n) {
        this.dynamicOCNo = n;
    }

    protected ValueMarker[] getValueMarkers() {
        ArrayList<ValueMarker> arrayList = new ArrayList<ValueMarker>();
        int n = this.markValues == null ? 0 : this.markValues.length;
        for (int i = 0; i < n; ++i) {
            if (i == this.dynamicOCadrs) continue;
            ValueMarker valueMarker = new ValueMarker(this.markValues[i]);
            valueMarker.setPaint((Paint)this.markColors[i]);
            if (this.useMarkAnchor) {
                valueMarker.setLabel(String.valueOf(this.markValues[i]));
                valueMarker.setLabelTextAnchor(TextAnchor.BASELINE_LEFT);
            }
            arrayList.add(valueMarker);
        }
        return arrayList.toArray(new ValueMarker[arrayList.size()]);
    }

    public void setLowerBound(String string) {
        if (string != null && string.length() > 0) {
            this.lowerBound = string;
        }
    }

    public void setUpperBound(String string) {
        if (string != null && string.length() > 0) {
            this.upperBound = string;
        }
    }

    public void setTickSize(String string) {
        if (string != null && string.length() > 0) {
            this.tickSize = string;
        }
    }

    public void setUseGradient(boolean bl) {
        this.useGradient = bl;
    }

    protected boolean isUseGradient() {
        return this.useGradient;
    }

    public void setShapesVisible(boolean bl) {
        this.shapesVisible = bl;
    }

    protected boolean isShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapeColors(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.shapeColors = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.shapeColors[i] = StringUtil.getColorInstance((String)stringArray[i]);
            }
        }
    }

    public void setShapeScale(String string) {
        this.shapeScale = string;
    }

    public void setUseDottedLine(boolean bl) {
        this.useDottedLine = bl;
    }

    protected boolean isUseDottedLine() {
        return this.useDottedLine;
    }

    public void setSeriesColors(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.seriesColors = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.seriesColors[i] = StringUtil.getColorInstance((String)stringArray[i]);
            }
        }
    }

    protected Color[] getSeriesColors() {
        return this.seriesColors;
    }

    public void setValueLabelsVisible(boolean bl) {
        this.isLabelsVisible = bl;
    }

    public void setValueMarksVisible(boolean bl) {
        this.isMarksVisible = bl;
    }

    public void setItemLabelVisible(String string) {
        if ("true".equalsIgnoreCase(string)) {
            this.isItemValVisible = true;
        } else if ("last".equalsIgnoreCase(string)) {
            this.isItemValVisible = true;
            this.isItemLastVisible = true;
        } else if (string != null && !"false".equalsIgnoreCase(string)) {
            String string2 = "itemLabelVisible \u306f\u3001\u300ctrue,false,last\u300d\u304b\u3089\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002[" + string + "]";
            throw new HybsSystemException(string2);
        }
    }

    public void setUseItemLabelSep(boolean bl) {
        this.useItemLabelSep = bl;
    }

    public void setValueInset(String string) {
        this.valueInset = string;
    }

    public void setBarWidth(String string) {
        this.barWidth = string;
    }

    protected String getBarWidth() {
        return this.barWidth;
    }

    public void setBarMaxWidth(String string) {
        this.maxBarWidth = string;
    }

    public void setBarItemMargin(String string) {
        this.itemMargin = string;
    }

    public void setVisibleLimit(String string) {
        this.visibleLimit = string;
    }

    public void setDomainMargin(double d) {
        this.domainMargin = d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("[").append(this.getClass().getName()).append("]").append(HybsSystem.CR);
        stringBuilder.append("chartType     [").append(this.chartType).append("]").append(HybsSystem.CR);
        stringBuilder.append("valueLabel    [").append(this.valueLabel).append("]").append(HybsSystem.CR);
        stringBuilder.append("markValues    [").append(Arrays.toString(this.markValues)).append("]").append(HybsSystem.CR);
        stringBuilder.append("markColors    [").append(Arrays.toString(this.markColors)).append("]").append(HybsSystem.CR);
        stringBuilder.append("lowerBound    [").append(this.lowerBound).append("]").append(HybsSystem.CR);
        stringBuilder.append("upperBound    [").append(this.upperBound).append("]").append(HybsSystem.CR);
        stringBuilder.append("useGradient   [").append(this.useGradient).append("]").append(HybsSystem.CR);
        stringBuilder.append("shapesVisible [").append(this.shapesVisible).append("]").append(HybsSystem.CR);
        stringBuilder.append("useDottedLine [").append(this.useDottedLine).append("]").append(HybsSystem.CR);
        return stringBuilder.toString();
    }
}

