/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.resource.ResourceManager;

public class DBMetaData {
    private String dbid = null;
    private ResourceManager resource = null;
    private ApplicationInfo appInfo = null;

    public void setDbid(String string) {
        this.dbid = string;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.appInfo = applicationInfo;
    }

    private DBTableModel makeDBTableModel(ResultSet resultSet) {
        int n;
        String[][] stringArray = DBUtil.resultToArray((ResultSet)resultSet, (boolean)true);
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        int n2 = stringArray[0].length;
        dBTableModel.init(n2);
        for (n = 0; n < n2; ++n) {
            String string = stringArray[0][n].toUpperCase(Locale.JAPAN);
            DBColumn dBColumn = this.resource.makeDBColumn(string);
            dBTableModel.setDBColumn(n, dBColumn);
        }
        for (n = 1; n < stringArray.length; ++n) {
            dBTableModel.addColumnValues(stringArray[n]);
        }
        return dBTableModel;
    }

    public DBTableModel getSchemas() {
        DBTableModel dBTableModel;
        Connection connection = null;
        try {
            connection = ConnectionFactory.connection((String)this.dbid, (ApplicationInfo)this.appInfo);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dBTableModel = this.makeDBTableModel(databaseMetaData.getSchemas());
        }
        catch (SQLException sQLException) {
            ConnectionFactory.remove((Connection)connection, (String)this.dbid);
            connection = null;
            throw new HybsSystemException(sQLException);
        }
        finally {
            ConnectionFactory.close((Connection)connection, (String)this.dbid);
        }
        return dBTableModel;
    }

    public DBTableModel getTables(String string, String string2, String string3) {
        DBTableModel dBTableModel;
        Connection connection = null;
        try {
            connection = ConnectionFactory.connection((String)this.dbid, (ApplicationInfo)this.appInfo);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dBTableModel = this.makeDBTableModel(databaseMetaData.getTables(string, string2, string3, null));
        }
        catch (SQLException sQLException) {
            ConnectionFactory.remove((Connection)connection, (String)this.dbid);
            connection = null;
            throw new HybsSystemException(sQLException);
        }
        finally {
            ConnectionFactory.close((Connection)connection, (String)this.dbid);
        }
        return dBTableModel;
    }

    public DBTableModel getColumns(String string, String string2, String string3, String string4) {
        DBTableModel dBTableModel;
        Connection connection = null;
        try {
            connection = ConnectionFactory.connection((String)this.dbid, (ApplicationInfo)this.appInfo);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dBTableModel = this.makeDBTableModel(databaseMetaData.getColumns(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            ConnectionFactory.remove((Connection)connection, (String)this.dbid);
            connection = null;
            throw new HybsSystemException(sQLException);
        }
        finally {
            ConnectionFactory.close((Connection)connection, (String)this.dbid);
        }
        return dBTableModel;
    }

    public DBTableModel getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        DBTableModel dBTableModel;
        Connection connection = null;
        try {
            connection = ConnectionFactory.connection((String)this.dbid, (ApplicationInfo)this.appInfo);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dBTableModel = this.makeDBTableModel(databaseMetaData.getIndexInfo(string, string2, string3, bl, bl2));
        }
        catch (SQLException sQLException) {
            ConnectionFactory.remove((Connection)connection, (String)this.dbid);
            connection = null;
            throw new HybsSystemException(sQLException);
        }
        finally {
            ConnectionFactory.close((Connection)connection, (String)this.dbid);
        }
        return dBTableModel;
    }

    public DBTableModel getProcedures(String string, String string2, String string3) {
        DBTableModel dBTableModel;
        Connection connection = null;
        try {
            connection = ConnectionFactory.connection((String)this.dbid, (ApplicationInfo)this.appInfo);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dBTableModel = this.makeDBTableModel(databaseMetaData.getProcedures(string, string2, string3));
        }
        catch (SQLException sQLException) {
            ConnectionFactory.remove((Connection)connection, (String)this.dbid);
            connection = null;
            throw new HybsSystemException(sQLException);
        }
        finally {
            ConnectionFactory.close((Connection)connection, (String)this.dbid);
        }
        return dBTableModel;
    }
}

