<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:ドキュメント管理"
	pgid     = "FILE01"
	title    = "ファイル種別"
	date     = "2010/09/25"
	author   = "H.NAKAMURA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,SYFILE,SYNAME,DESCRIPTION"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select
			SYFILE,SYNAME,DESCRIPTION,HINAGATA,SAVE_FOLDER,FILE_URL,ICON_URL,ROLES
			,SU_LMT,DY_LMT,SIZE_LMT,SUFFIX_LMT,FGANGO,FGZIP,SYSTEM_ID,FGJ,DYUPD,UNIQ
		from GE38
	</jsp:text>
	<og:where>
		<og:and value = "FGJ		=	'{@FGJ}'"		/>
		<og:and value = "SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "SYFILE			like '{@SYFILE}%'"	/>
		<og:and value = "SYNAME			like '{@SYNAME}%'"	/>
		<og:and value = "DESCRIPTION	like '{@DESCRIPTION}%'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,SYFILE" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,SYFILE,SYNAME" must="true" />

<og:viewMarker command="{@command}">
	<og:columnMarker column="HINAGATA">
		<a href="[HINAGATA]" target="_blank">[HINAGATA]</a>
	</og:columnMarker>
</og:viewMarker>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals="null" />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals="SYFILE" />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable,logicalDelete" vals="null,true" />
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay     = "UNIQ"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
