/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBFunctionName;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.resource.ResourceManager;
import org.opengion.hayabusa.resource.UserInfo;

public class FileManager {
    private static final String FS = File.separator;
    private static final String US = "/";
    private static final String DEFAULT_FILE_PATH = HybsSystem.sys("FILEMG_DEFAULT_FILE_PATH");
    private static final String DEFAULT_FILE_URL = HybsSystem.sys("FILEMG_DEFAULT_FILE_URL");
    private static final String DEFAULT_SYFILE = "**";
    private static final FileManager manager = new FileManager();
    private String dbid = null;
    private Transaction tran = null;
    private ResourceManager res = null;
    private UserInfo user = null;
    private DBFunctionName dbName = null;
    private boolean isInit = true;
    private static final String GE38_NAMES = " SYFILE,SYNAME,DESCRIPTION,HINAGATA,SAVE_FOLDER,FILE_URL,ICON_URL,ROLES,SU_LMT,DY_LMT,FGANGO,FGZIP,SIZE_LMT,SUFFIX_LMT";
    private final String[] GE38_NAME_ARR = StringUtil.csv2Array((String)" SYFILE,SYNAME,DESCRIPTION,HINAGATA,SAVE_FOLDER,FILE_URL,ICON_URL,ROLES,SU_LMT,DY_LMT,FGANGO,FGZIP,SIZE_LMT,SUFFIX_LMT");
    private static final String GE38_SELECT = "select  SYFILE,SYNAME,DESCRIPTION,HINAGATA,SAVE_FOLDER,FILE_URL,ICON_URL,ROLES,SU_LMT,DY_LMT,FGANGO,FGZIP,SIZE_LMT,SUFFIX_LMT from GE38 where SYSTEM_ID=? and SYFILE=? and FGJ='1'";
    private static final String GE39_NAMES = " UNIQ_ID,SEQNO,SYFILE,SUFFIX,REF_KEY,SYSTEM_ID,SYNAME,SAVE_FOLDER,FILE_URL,ICON_URL,ROLES,SU_LMT,DY_LMT,FGANGO,FGZIP,FILE_NAME,CONTENTS,FG_NEW,SIZE_FILE,DYFILESET,USRTOROKU,SETGUIID,FGKOSHIN,FGKOKAI,SRCHKEY1,SRCHKEY2,SRCHKEY3,SRCHKEY4,SRCHKEY5,SRCHKEY6,SRCHKEY7,SRCHKEY8,SRCHKEY9,SRCHKEY10";
    private final String[] GE39_NAME_ARR = StringUtil.csv2Array((String)" UNIQ_ID,SEQNO,SYFILE,SUFFIX,REF_KEY,SYSTEM_ID,SYNAME,SAVE_FOLDER,FILE_URL,ICON_URL,ROLES,SU_LMT,DY_LMT,FGANGO,FGZIP,FILE_NAME,CONTENTS,FG_NEW,SIZE_FILE,DYFILESET,USRTOROKU,SETGUIID,FGKOSHIN,FGKOKAI,SRCHKEY1,SRCHKEY2,SRCHKEY3,SRCHKEY4,SRCHKEY5,SRCHKEY6,SRCHKEY7,SRCHKEY8,SRCHKEY9,SRCHKEY10");
    private final String GE39_REFKEY_SELECT = "select  UNIQ_ID,SEQNO,SYFILE,SUFFIX,REF_KEY,SYSTEM_ID,SYNAME,SAVE_FOLDER,FILE_URL,ICON_URL,ROLES,SU_LMT,DY_LMT,FGANGO,FGZIP,FILE_NAME,CONTENTS,FG_NEW,SIZE_FILE,DYFILESET,USRTOROKU,SETGUIID,FGKOSHIN,FGKOKAI,SRCHKEY1,SRCHKEY2,SRCHKEY3,SRCHKEY4,SRCHKEY5,SRCHKEY6,SRCHKEY7,SRCHKEY8,SRCHKEY9,SRCHKEY10 from GE39 where REF_KEY=? and FG_NEW='1' and FGJ='1' order by UNIQ_ID desc, SEQNO desc";
    private final String GE39_REFKEY_SYFILE = "select  UNIQ_ID,SEQNO,SYFILE,SUFFIX,REF_KEY,SYSTEM_ID,SYNAME,SAVE_FOLDER,FILE_URL,ICON_URL,ROLES,SU_LMT,DY_LMT,FGANGO,FGZIP,FILE_NAME,CONTENTS,FG_NEW,SIZE_FILE,DYFILESET,USRTOROKU,SETGUIID,FGKOSHIN,FGKOKAI,SRCHKEY1,SRCHKEY2,SRCHKEY3,SRCHKEY4,SRCHKEY5,SRCHKEY6,SRCHKEY7,SRCHKEY8,SRCHKEY9,SRCHKEY10 from GE39 where REF_KEY=? and SYSTEM_ID=? and SYFILE=? and FG_NEW='1' and FGJ='1' order by UNIQ_ID desc, SEQNO desc";
    private final String GE39_INSERT = "insert into GE39 ( UNIQ_ID,SEQNO,SYFILE,SUFFIX,REF_KEY,SYSTEM_ID,SYNAME,SAVE_FOLDER,FILE_URL,ICON_URL,ROLES,SU_LMT,DY_LMT,FGANGO,FGZIP,FILE_NAME,CONTENTS,FG_NEW,SIZE_FILE,DYFILESET,USRTOROKU,SETGUIID,FGKOSHIN,FGKOKAI,SRCHKEY1,SRCHKEY2,SRCHKEY3,SRCHKEY4,SRCHKEY5,SRCHKEY6,SRCHKEY7,SRCHKEY8,SRCHKEY9,SRCHKEY10,FGJ,DYSET,PGSET,USRSET,DYUPD,PGUPD,USRUPD) values (  ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
    private final String GE39_FGNEW_UPDATE = "update GE39 set FG_NEW='0' where UNIQ_ID=? and FG_NEW='1'";

    private FileManager() {
    }

    public static FileManager getInstance() {
        return manager;
    }

    public void setDbid(String string) {
        this.dbid = string;
    }

    public void setTransaction(Transaction transaction) {
        this.tran = transaction;
    }

    public void setResource(ResourceManager resourceManager) {
        this.res = resourceManager;
    }

    public void setUser(UserInfo userInfo) {
        this.user = userInfo;
    }

    public void init() {
        if (this.tran == null) {
            this.tran = new TransactionReal(this.dbid, new ApplicationInfo());
        }
        this.dbName = DBFunctionName.getDBName((String)ConnectionFactory.getDBName((String)this.dbid));
        this.isInit = false;
    }

    public DBTableModel view() {
        FileData[] fileDataArray;
        String string = "SYNAME,FILE_NAME,CONTENTS";
        String[] stringArray = StringUtil.csv2Array((String)string);
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            fileDataArray = this.res.makeDBColumn(stringArray[i]);
            dBTableModel.setDBColumn(i, (DBColumn)fileDataArray);
        }
        FileList fileList = new FileList();
        for (FileData fileData : fileDataArray = fileList.getFileList()) {
            String[] stringArray2 = fileData.get(stringArray);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!"FILE_NAME".equals(stringArray[i]) || stringArray2[i] == null || stringArray2[i].length() <= 0) continue;
                String string2 = fileData.get("FILE_URL");
                String string3 = StringUtil.nval((String)string2, (String)DEFAULT_FILE_URL);
                if (!(string3.startsWith("http://") || string3.startsWith("https://") || string3.startsWith(US))) {
                    string3 = StringUtil.urlAppend((String)(US + HybsSystem.sys("CONTEXT_NAME")), (String)string3);
                }
                string3 = StringUtil.urlAppend((String)string3, (String)fileData.get("UNIQ_ID"));
                String string4 = string3 + US + fileData.get("SEQNO") + "." + fileData.get("SUFFIX");
                TagBuffer tagBuffer = new TagBuffer("a");
                tagBuffer.add("href", string4);
                tagBuffer.setBody(stringArray2[i]);
                stringArray2[i] = tagBuffer.makeTag();
            }
            dBTableModel.addColumnValues(stringArray2);
        }
        return dBTableModel;
    }

    public DBTableModel input(int n) {
        String[] stringArray;
        Object object;
        int n2;
        String string = "SYNAME,UPFILE,CONTENTS,DESCRIPTION,HINAGATA";
        String[] stringArray2 = StringUtil.csv2Array((String)string);
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(stringArray2.length);
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            object = this.res.makeDBColumn(stringArray2[n2]);
            if ("UPFILE".equals(stringArray2[n2])) {
                stringArray = ((DBColumn)object).getConfig();
                stringArray.setEditor("UPLOAD");
                object = new DBColumn((DBColumnConfig)stringArray);
            }
            dBTableModel.setDBColumn(n2, (DBColumn)object);
        }
        for (n2 = 0; n2 < n; ++n2) {
            object = new TemplateData(DEFAULT_SYFILE);
            stringArray = ((TemplateData)object).get(stringArray2);
            dBTableModel.addColumnValues(stringArray);
        }
        return dBTableModel;
    }

    public static String getName(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = (string2 = new File(string).getName()).lastIndexOf(46)) >= 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String getSuffix(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.lastIndexOf(46)) >= 0) {
            string2 = string.substring(n + 1).toLowerCase(Locale.JAPAN);
        }
        return string2;
    }

    private class FileData {
        private final String syfile;
        private final String uniqId;
        private final String seqNo;
        private final boolean exists = false;
        private final Map<String, String> data = new HashMap<String, String>();

        public FileData(String string) {
            this.syfile = null;
            this.uniqId = null;
            this.seqNo = null;
            if (FileManager.DEFAULT_SYFILE.equals(this.syfile)) {
                // empty if block
            }
        }

        public FileData(String[] stringArray) {
            this.syfile = null;
            this.uniqId = null;
            this.seqNo = null;
            if (!FileManager.DEFAULT_SYFILE.equals(this.syfile) && stringArray != null && stringArray.length != 0) {
                for (int i = 0; i < FileManager.this.GE39_NAME_ARR.length; ++i) {
                    this.data.put(FileManager.this.GE39_NAME_ARR[i], stringArray[i]);
                }
            }
        }

        public String get(String string) {
            return this.data.get(string);
        }

        public String[] get(String[] stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = this.data.get(stringArray[i]);
            }
            return stringArray2;
        }

        public void insert(String string, String string2, String string3) {
            String string4 = String.valueOf(FileManager.this.dbName.getSequence("GE39S02", FileManager.this.tran));
            String string5 = String.valueOf(Integer.valueOf(this.seqNo) + 1);
            TemplateData templateData = new TemplateData(this.syfile);
            String string6 = FileManager.getName(string);
            String string7 = FileManager.getSuffix(string);
            String string8 = templateData.get("SAVE_FOLDER");
            String string9 = StringUtil.nval((String)string8, (String)DEFAULT_FILE_PATH);
            string9 = HybsSystem.url2dir(string9);
            string9 = StringUtil.urlAppend((String)string9, (String)this.uniqId);
            String string10 = string9 + FS + string5 + "." + string7;
            new File(string9).mkdirs();
            FileUtil.copy((String)string, (String)string10);
        }
    }

    private class FileList {
        private final List<FileData> list = new ArrayList<FileData>();

        public FileData[] getFileList() {
            return this.list.toArray(new FileData[0]);
        }
    }

    private class TemplateData {
        private Map<String, String> data = new HashMap<String, String>();

        public TemplateData(String string) {
            if (FileManager.DEFAULT_SYFILE.equals(string)) {
                this.data.put("SYFILE", FileManager.DEFAULT_SYFILE);
                this.data.put("SU_LMT", "0");
                this.data.put("DY_LMT", "0");
                this.data.put("SIZE_LMT", "0");
                this.data.put("FGANGO", "0");
                this.data.put("FGZIP", "0");
            }
        }

        public String get(String string) {
            return this.data.get(string);
        }

        public String[] get(String[] stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = this.data.get(stringArray[i]);
            }
            return stringArray2;
        }
    }

    public static enum ACTION {
        LIST,
        UPLOAD;

    }
}

