/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.db.DBSysArg;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.db.DBUserArg;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.ResourceManager;

public class AbstractQuery
implements Query {
    private Connection connection = null;
    private Transaction transaction = null;
    private int rtnCode = 0;
    private ErrorMessage errMessage = null;
    private ResourceManager resource = null;
    private DBTableModel table = null;
    private String connID = null;
    private String stmtString = null;
    private int executeCount = -1;
    private int skipRowCount = 0;
    private int maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
    private boolean updateFlag = true;
    protected static final int DB_MAX_QUERY_TIMEOUT = HybsSystem.sysInt("DB_MAX_QUERY_TIMEOUT");
    public static final String ARG_ARRAY = "ARG_ARRAY";
    public static final String SYSARG_ARRAY = "SYSARG_ARRAY";
    public static final String ERR_MSG = "ERR_MSG";
    public static final String ERR_MSG_ARRAY = "ERR_MSG_ARRAY";

    @Override
    public void init() {
        this.close();
        this.rtnCode = 0;
        this.errMessage = null;
        this.resource = null;
        this.table = null;
        this.connID = null;
        this.stmtString = null;
        this.executeCount = -1;
        this.skipRowCount = 0;
        this.maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
        this.updateFlag = true;
        this.connection = null;
    }

    @Override
    public void setStatement(String string) {
        this.stmtString = string.trim();
    }

    @Override
    public String getStatement() {
        return this.stmtString;
    }

    @Override
    public void execute() {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute()";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public void execute(String[] stringArray) {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( String[] )";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public void execute(String[] stringArray, String[] stringArray2) {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( String[],String[] )";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public void execute(String string, String string2, DBSysArg[] dBSysArgArray, DBUserArg[] dBUserArgArray) {
        String string3 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( String,String,DBSysArg[],DBUserArg[] )";
        throw new UnsupportedOperationException(string3);
    }

    @Override
    public void execute(int[] nArray, DBTableModel dBTableModel) {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( final int[] rowNo, final DBTableModel table )";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public void commit() {
        if (this.transaction == null) {
            return;
        }
        if (!this.transaction.commit()) {
            this.transaction.rollback();
            this.realClose();
            String string = "\u30b3\u30df\u30c3\u30c8\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + this.getStatement() + HybsSystem.CR;
            throw new HybsSystemException(string);
        }
    }

    @Override
    public void rollback() {
        if (this.transaction == null) {
            return;
        }
        if (!this.transaction.rollback()) {
            this.realClose();
            String string = "\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + HybsSystem.CR + this.getStatement() + HybsSystem.CR;
            throw new HybsSystemException(string);
        }
    }

    @Override
    public void close() {
        if (this.transaction != null) {
            this.transaction.close();
            this.transaction = null;
        }
    }

    @Override
    public void realClose() {
        if (this.transaction != null) {
            this.transaction.close(true);
            this.transaction = null;
        }
    }

    protected void setExecuteCount(int n) {
        this.executeCount = n;
    }

    @Override
    public int getExecuteCount() {
        return this.executeCount;
    }

    protected void setDBTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    @Override
    public void setMaxRowCount(int n) {
        this.maxRowCount = n > 0 ? n : Integer.MAX_VALUE;
    }

    @Override
    public int getSkipRowCount() {
        return this.skipRowCount;
    }

    @Override
    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    protected void setUpdateFlag(boolean bl) {
        this.updateFlag = bl;
    }

    @Override
    public boolean isUpdate() {
        return this.updateFlag;
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    public String getLang() {
        String string = null;
        if (this.resource != null) {
            string = this.resource.getLang();
        }
        return string;
    }

    @Override
    public int getErrorCode() {
        return this.rtnCode;
    }

    protected void setErrorCode(int n) {
        this.rtnCode = n;
    }

    @Override
    public ErrorMessage getErrorMessage() {
        return this.errMessage;
    }

    protected void setErrorMessage(ErrorMessage errorMessage) {
        this.errMessage = errorMessage;
    }

    protected void createTableModel(ResultSet resultSet) {
        try {
            String[] stringArray;
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            this.table = DBTableModelUtil.newDBTable();
            this.table.init(n2);
            DBColumn[] dBColumnArray = new DBColumn[n2];
            boolean bl = false;
            int[] nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                stringArray = resultSetMetaData.getColumnLabel(n + 1).toUpperCase(Locale.JAPAN);
                dBColumnArray[n] = this.resource.getDBColumn((String)stringArray);
                if (dBColumnArray[n] == null) {
                    LabelData labelData = this.resource.getLabelData((String)stringArray);
                    dBColumnArray[n] = this.makeDBColumn((String)stringArray, labelData, resultSetMetaData, n);
                }
                this.table.setDBColumn(n, dBColumnArray[n]);
                nArray[n] = resultSetMetaData.getColumnType(n + 1);
                if (nArray[n] != 2005 && nArray[n] != -8) continue;
                bl = true;
            }
            for (n = 0; n < this.getSkipRowCount() && resultSet.next(); ++n) {
            }
            n = 0;
            if (bl) {
                while (n < this.maxRowCount && resultSet.next()) {
                    ++n;
                    stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        Object object;
                        if (nArray[i] == 2005) {
                            object = resultSet.getObject(i + 1);
                            stringArray[i] = this.getClobData((Clob)object);
                            continue;
                        }
                        if (nArray[i] == -8) {
                            object = resultSet.getString(i + 1);
                            if (object == null) {
                                stringArray[i] = "";
                                continue;
                            }
                            stringArray[i] = object;
                            continue;
                        }
                        object = resultSet.getObject(i + 1);
                        stringArray[i] = object == null ? "" : String.valueOf(object);
                    }
                    this.table.addColumnValues(stringArray);
                }
            } else {
                while (n < this.maxRowCount && resultSet.next()) {
                    ++n;
                    stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        Object object = resultSet.getObject(i + 1);
                        stringArray[i] = object == null ? "" : String.valueOf(object);
                    }
                    this.table.addColumnValues(stringArray);
                }
            }
            if (n >= this.maxRowCount && resultSet.next()) {
                this.table.setOverflow(true);
            }
            this.setExecuteCount(n);
        }
        catch (SQLException sQLException) {
            this.realClose();
            String string = "\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            throw new HybsSystemException(string, sQLException);
        }
    }

    private DBColumn makeDBColumn(String string, LabelData labelData, ResultSetMetaData resultSetMetaData, int n) {
        DBColumn dBColumn;
        try {
            String string2 = this.type2ClassName(resultSetMetaData.getColumnType(n + 1));
            int n2 = resultSetMetaData.getColumnDisplaySize(n + 1);
            if (n2 == 0) {
                n2 = 60;
            }
            boolean bl = resultSetMetaData.isWritable(n + 1);
            String string3 = "NUMBER".equals(string2) ? "S9" : "XK";
            String string4 = "NUMBER".equals(string2) ? "0" : "";
            DBColumnConfig dBColumnConfig = new DBColumnConfig(this.getLang(), string, labelData, string2, String.valueOf(n2), String.valueOf(bl), null, null, null, string3, string4, null, null, null, null, false, null);
            dBColumn = new DBColumn(dBColumnConfig);
        }
        catch (SQLException sQLException) {
            this.realClose();
            String string5 = "DBColumn \u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002name=[" + string + " , label=[" + labelData + "]";
            throw new HybsSystemException(string5, sQLException);
        }
        catch (RuntimeException runtimeException) {
            this.realClose();
            String string6 = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002name=[" + string + " , label=[" + labelData + "]";
            throw new HybsSystemException(string6, runtimeException);
        }
        return dBColumn;
    }

    protected Connection getConnection() {
        if (this.connection == null) {
            if (this.transaction == null) {
                String string = "Transaction \u3092\u30bb\u30c3\u30c8\u3059\u308b\u524d\u306b\u3001\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u3092\u53d6\u308a\u51fa\u3059\u8981\u6c42\u304c\u306a\u3055\u308c\u307e\u3057\u305f\u3002" + HybsSystem.CR + "connID = [" + this.connID + "]";
                throw new HybsSystemException(string);
            }
            this.connection = this.transaction.getConnection(this.connID);
        }
        return this.connection;
    }

    @Override
    public void setTransaction(String string, Transaction transaction) {
        if (this.transaction != null) {
            String string2 = "\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u306f\u3001\u3059\u3067\u306b\u8a2d\u5b9a\u6e08\u307f\u3067\u3059\u3002" + HybsSystem.CR + "connID = [" + string + "]";
            throw new HybsSystemException(string2);
        }
        this.transaction = transaction;
        this.connID = string;
    }

    protected String type2ClassName(int n) {
        String string;
        switch (n) {
            case -7: 
            case 1: 
            case 12: {
                string = "VARCHAR2";
                break;
            }
            case -1: {
                string = "LONG";
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "NUMBER";
                break;
            }
            case 91: {
                string = "DATE";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            default: {
                string = "NONE";
            }
        }
        return string;
    }

    private String getClobData(Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        Reader reader = null;
        StringBuilder stringBuilder = new StringBuilder(10000);
        try {
            int n;
            reader = clob.getCharacterStream();
            char[] cArray = new char[10000];
            while ((n = reader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            String string = "CLOB\u30c7\u30fc\u30bf\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            throw new HybsSystemException(string, iOException);
        }
        finally {
            Closer.ioClose((Closeable)reader);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "LastQuery  :[" + this.getStatement() + "] ";
    }
}

