<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
    xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:og="hybs-taglib.tld"
    version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6380"
	title	= "ファイルクエリー"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:select name="FileOption">
    <og:fileOption
		from	= "{@FILE_DIRECTORY}"
		value	= "{@VALUE}"
		orderBy	= "{@ORDERBY}"
		desc	= "{@DESC}">
			<og:fileWhere
				startsWith		= "{@STARTSWITH}"
				endsWith		= "{@ENDSWITH}"
				instr			= "{@INSTR}"
				equals			= "{@FILEEQUALS}"
				matches			= "{@MATCHES}"
				unMatches		= "{@UNMATCHES}"
				lastModified	= "{@LASTMODIFIED}"
				isLarger		= "{@ISLARGER}"
				isSmaller		= "{@ISSMALLER}"
			/>
    </og:fileOption>
</og:select>

<BR/>
<og:message lbl="FileQuery:" />
<BR/>
<og:fileQuery from="{@FILE_DIRECTORY}" multi="{@FILE_MULTI}" level="{@SAERCH_LEVEL}">
	<og:fileWhere
		startsWith		= "{@STARTSWITH}"
		endsWith		= "{@ENDSWITH}"
		instr			= "{@INSTR}"
		equals			= "{@FILEEQUALS}"
		matches			= "{@MATCHES}"
		unMatches		= "{@UNMATCHES}"
		lastModified	= "{@LASTMODIFIED}"
		isLarger		= "{@ISLARGER}"
		isSmaller		= "{@ISSMALLER}"
	/>
</og:fileQuery>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="NAME" href="../fileDownload" useGamenId="false" target="_NEW" 
		keys="file,name" vals="[PARENT]/[NAME],[NAME]" />
</og:viewLink>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
