/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.mail.MailPattern;

public abstract class AbstractMailManager {
    private static final String CONTENTS = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "CONTENT" : "CONTENTS";
    private static final String selYkno = "SELECT GE32S02.NEXTVAL YKNO FROM DUAL";
    private static final String insGE32 = "INSERT INTO GE32(YKNO,PARA_KEY,PTN_ID,FROM_ADDR,TITLE," + CONTENTS + ",ATTACH1,ATTACH2,ATTACH3,ATTACH4,ATTACH5,DYSET,USRSET,PGUPD,SYSTEM_ID,FGJ)" + " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'1')";
    private static final String insGE34 = "INSERT INTO GE34(YKNO,DST_ID,GROUP_ID,DST_NAME,DST_ADDR,DST_KBN,FGJ,DYSET,USRSET,PGUPD) VALUES(?,?,?,?,?,?,?,?,?,?)";
    protected static final String FGJ_SEND_WAIT = "0";
    protected static final String FGJ_SEND_OVER = "1";
    protected static final String FGJ_ADDR_ERR = "7";
    protected static final String FGJ_ACNT_ERR = "8";
    private static final int GE32_YKNO = 0;
    private static final int GE32_PARAKEY = 1;
    private static final int GE32_PTN_ID = 2;
    private static final int GE32_FROM_ADDR = 3;
    private static final int GE32_TITLE = 4;
    private static final int GE32_CONTENTS = 5;
    private static final int GE32_ATTACH1 = 6;
    private static final int GE32_ATTACH2 = 7;
    private static final int GE32_ATTACH3 = 8;
    private static final int GE32_ATTACH4 = 9;
    private static final int GE32_ATTACH5 = 10;
    private static final int GE32_DYSET = 11;
    private static final int GE32_USRSET = 12;
    private static final int GE32_PGUPD = 13;
    private static final int GE32_SYSTEM_ID = 14;
    private static final int GE34_YKNO = 0;
    private static final int GE34_DST_ID = 1;
    private static final int GE34_GROUP_ID = 2;
    private static final int GE34_DST_NAME = 3;
    private static final int GE34_DST_ADDR = 4;
    private static final int GE34_DST_KBN = 5;
    private static final int GE34_FGJ = 6;
    private static final int GE34_DYSET = 7;
    private static final int GE34_USRSET = 8;
    private static final int GE34_PGUPD = 9;
    private static String host = HybsSystem.sys("COMMON_MAIL_SERVER");
    private static String charset = HybsSystem.sys("MAIL_DEFAULT_CHARSET");
    private boolean debugFlag = false;
    private final List<String> errAddrList = new ArrayList<String>();
    private static final int MAX_RETRY = 3;
    private String mailTitle;
    private String mailContent;
    private String fromAddr;
    private String[] attachFiles;
    private Map<String, String[]> mailDstMap = null;
    private Map<String, String> initParamMap = null;
    private MailTX mail = null;
    private static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    public static final ApplicationInfo appInfo;

    public void create(Map<String, String> map) {
        this.initParamMap = map;
        MailPattern mailPattern = new MailPattern(map);
        this.fromAddr = mailPattern.getFromAddr();
        this.setAttachFiles(map.get("ATTACH1"), map.get("ATTACH2"), map.get("ATTACH3"), map.get("ATTACH4"), map.get("ATTACH5"));
        this.mailDstMap = mailPattern.getDstMap();
        this.mailTitle = mailPattern.getTitle();
        this.mailContent = mailPattern.getContent();
        this.errAddrList.addAll(mailPattern.getErrList());
    }

    public void send() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.mail = new MailTX(host, charset);
        this.mail.setFrom(this.fromAddr);
        this.mail.setFilename(this.attachFiles);
        this.mail.setSubject(this.mailTitle);
        this.mail.setMessage(this.mailContent);
        this.mail.setDebug(this.debugFlag);
        this.setMailDst(arrayList);
        int n = 3;
        while (n > 0) {
            Object object;
            Object object2;
            try {
                this.mail.sendmail();
            }
            catch (RuntimeException runtimeException) {
                object2 = runtimeException.getCause();
                if (object2 instanceof SendFailedException) {
                    object = ((SendFailedException)object2).getInvalidAddresses();
                    if (object != null) {
                        int n2 = ((Address[])object).length;
                        for (int i = 0; i < n2; ++i) {
                            arrayList.add(((InternetAddress)object[i]).getAddress());
                        }
                    }
                }
                object = "\u9001\u4fe1\u6642\u306b\u30a8\u30e9\u30fc\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + runtimeException.getMessage();
                throw new RuntimeException((String)object, runtimeException);
            }
            if (arrayList.isEmpty()) {
                n = -1;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuilder.append(',').append((String)arrayList.get(i));
            }
            object2 = this.getUserIds(arrayList);
            object = "\u30a2\u30c9\u30ec\u30b9\u30a8\u30e9\u30fc\u3002\u30e6\u30fc\u30b6\u30fcID\uff1a" + (String)object2 + " \u30a2\u30c9\u30ec\u30b9\uff1a" + stringBuilder.toString().substring(1);
            if ("true".equals(this.initParamMap.get("ADDR_CHECK"))) {
                throw new RuntimeException((String)object);
            }
            this.setMailDst(arrayList);
            --n;
            arrayList.clear();
            this.errAddrList.add((String)object);
        }
        this.commitMailDB();
    }

    public void setDebug(boolean bl) {
        this.debugFlag = bl;
    }

    public void setFromAddr(String string) {
        this.fromAddr = string;
    }

    public void setTitle(String string) {
        this.mailTitle = string;
    }

    public void setContent(String string) {
        this.mailContent = string;
    }

    public String getFromAddr() {
        return this.fromAddr;
    }

    public String getTitle() {
        return this.mailTitle;
    }

    public String getContent() {
        return this.mailContent;
    }

    protected void commitMailDB() {
        String string;
        String[] stringArray = new String[15];
        stringArray[0] = string = this.getYkno();
        stringArray[1] = this.initParamMap.get("PARAKEY");
        stringArray[2] = this.trim(this.initParamMap.get("PTN_ID"), 20);
        stringArray[3] = this.trim(this.fromAddr, 100);
        stringArray[4] = this.trim(this.mailTitle, 300);
        stringArray[5] = this.trim(this.mailContent, 4000);
        stringArray[6] = "";
        stringArray[7] = "";
        stringArray[8] = "";
        stringArray[9] = "";
        stringArray[10] = "";
        if (this.attachFiles != null) {
            int n = this.attachFiles.length;
            for (int i = 0; i < n; ++i) {
                stringArray[6 + i] = this.trim(this.attachFiles[i], 256);
            }
        }
        stringArray[11] = HybsSystem.getDate("yyyyMMddHHmmss");
        stringArray[12] = this.initParamMap.get("LOGIN_USERID");
        stringArray[13] = this.initParamMap.get("PGID");
        stringArray[14] = this.initParamMap.get("SYSTEM_ID");
        DBUtil.dbExecute((String)insGE32, (String[])stringArray, (ApplicationInfo)appInfo);
        String[] stringArray2 = new String[10];
        stringArray2[0] = string;
        for (String string2 : this.mailDstMap.keySet()) {
            stringArray2[1] = this.trim(this.mailDstMap.get(string2)[0], 10);
            stringArray2[2] = this.trim(this.mailDstMap.get(string2)[1], 20);
            stringArray2[3] = this.trim(this.mailDstMap.get(string2)[3], 20);
            stringArray2[4] = this.trim(this.mailDstMap.get(string2)[4], 100);
            stringArray2[5] = this.mailDstMap.get(string2)[5];
            stringArray2[6] = this.mailDstMap.get(string2)[6];
            stringArray2[7] = HybsSystem.getDate("yyyyMMddHHmmss");
            stringArray2[8] = this.initParamMap.get("LOGIN_USERID");
            stringArray2[9] = this.initParamMap.get("PGID");
            DBUtil.dbExecute((String)insGE34, (String[])stringArray2, (ApplicationInfo)appInfo);
        }
    }

    protected void setInitParams(Map<String, String> map) {
        this.initParamMap = map;
    }

    protected void setAttachFiles(String string, String string2, String string3, String string4, String string5) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() != 0) {
            arrayList.add(string);
        }
        if (string2 != null && string2.length() != 0) {
            arrayList.add(string2);
        }
        if (string3 != null && string3.length() != 0) {
            arrayList.add(string3);
        }
        if (string4 != null && string4.length() != 0) {
            arrayList.add(string4);
        }
        if (string5 != null && string5.length() != 0) {
            arrayList.add(string5);
        }
        this.attachFiles = arrayList.toArray(new String[arrayList.size()]);
    }

    protected void setMailDstMap(Map<String, String[]> map) {
        this.mailDstMap = map;
    }

    protected Map<String, String[]> getMailDstMap() {
        return this.mailDstMap;
    }

    protected String trim(String string, int n) {
        String string2 = string;
        if (string != null && string.length() > n) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    protected List<String> getErrList() {
        return this.errAddrList;
    }

    private void setMailDst(List<String> list) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        HashMap hashMap = new HashMap();
        hashMap.put(0, arrayList);
        hashMap.put(1, arrayList2);
        hashMap.put(2, arrayList3);
        for (String stringArray2 : this.mailDstMap.keySet()) {
            String[] stringArray = this.mailDstMap.get(stringArray2);
            Integer n = Integer.valueOf(stringArray[5]);
            if (!list.contains(stringArray[4]) && !FGJ_ADDR_ERR.equals(stringArray[6])) {
                stringArray[6] = FGJ_SEND_OVER;
                String string = stringArray[3];
                if (string != null && string.length() > 0) {
                    ((ArrayList)hashMap.get(n)).add(stringArray[3] + "<" + stringArray[4] + ">");
                    continue;
                }
                ((ArrayList)hashMap.get(n)).add(stringArray[4]);
                continue;
            }
            if (!FGJ_SEND_OVER.equals(stringArray[6])) continue;
            stringArray[6] = FGJ_ACNT_ERR;
        }
        this.mail.clearTo();
        this.mail.clearCc();
        this.mail.clearBcc();
        boolean bl = false;
        if (!arrayList.isEmpty()) {
            bl = true;
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            this.mail.setTo(stringArray);
        }
        if (!arrayList2.isEmpty()) {
            bl = true;
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            this.mail.setCc(stringArray);
        }
        if (!arrayList3.isEmpty()) {
            bl = true;
            String[] stringArray = arrayList3.toArray(new String[arrayList3.size()]);
            this.mail.setBcc(stringArray);
        }
        if (!bl) {
            String string = "\u5b9b\u5148\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u6709\u52b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002TO , CC , BCC \u306e\u3044\u3065\u308c\u306b\u3082\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string);
        }
    }

    private String getYkno() {
        String[][] stringArray = DBUtil.dbExecute((String)selYkno, (String[])new String[0], (ApplicationInfo)appInfo);
        if (stringArray == null || stringArray.length == 0) {
            String string = "\u8981\u6c42NO\u63a1\u756a\u30a8\u30e9\u30fc SQL=SELECT GE32S02.NEXTVAL YKNO FROM DUAL";
            throw new RuntimeException(string);
        }
        return stringArray[0][0];
    }

    private String getUserIds(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.mailDstMap.keySet()) {
            String[] stringArray = this.mailDstMap.get(string);
            hashMap.put(stringArray[4], string);
        }
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(',').append((String)hashMap.get(list.get(i)));
        }
        String string = "";
        if (stringBuilder.length() > 0) {
            string = stringBuilder.toString().substring(1);
        }
        return string;
    }

    static {
        if (USE_DB_APPLICATION_INFO) {
            appInfo = new ApplicationInfo();
            appInfo.setClientInfo("MailModuel", HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            appInfo.setModuleInfo("MailModuel", "MailManager", "MailManager");
        } else {
            appInfo = null;
        }
    }
}

