/**************************************************************************/
/* GE56 ( 帳票エラーテーブル )                                            */
/*                                                                        */
/* Created : 2011/08/05 08:07:12                                          */
/**************************************************************************/
CREATE TABLE GE56 (
   SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 10  システムID       */
 , YKNO      NUMBER(9)         DEFAULT 0   NOT NULL      /* 20  要求ＮＯ         */
 , ERRMSG    VARCHAR2(4000)                              /* 30  エラーメッセージ */
 , UNIQSEQ   NUMBER(9)         DEFAULT 0   NOT NULL      /* 50  シーケンス番号   */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 810 状態フラグ       */
 , DYSET     VARCHAR2(14)                                /* 820 登録日時         */
 , PGSET     VARCHAR2(10)                                /* 830 作成PG           */
 , PGPSET    VARCHAR2(10)                                /* 840 作成親PG         */
 , USRSET    VARCHAR2(10)                                /* 850 作成社員         */
 , DYUPD     VARCHAR2(14)                                /* 860 更新日時         */
 , PGUPD     VARCHAR2(10)                                /* 870 更新PG           */
 , PGPUPD    VARCHAR2(10)                                /* 880 更新親PG         */
 , USRUPD    VARCHAR2(10)                                /* 890 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 704K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE56S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE56T00 
BEFORE INSERT ON GE56
FOR EACH ROW 
BEGIN 
SELECT GE56S00.NEXTVAL INTO :NEW.UNIQSEQ FROM DUAL; 
END; 
/

