/**************************************************************************/
/* GF65 ( プロジェクトリソース定義 )                                      */
/*                                                                        */
/* Created : 2011/08/31 19:04:50                                          */
/**************************************************************************/
CREATE TABLE GF65 (
   PRJCODE     VARCHAR(30)                              /* 10  PRJコード    */
 , RESOURCE_ID NUMERIC(9)                               /* 20  リソースID   */
 , SEQ         NUMERIC(7)     DEFAULT 0   NOT NULL      /* 30  順           */
 , FUNC        VARCHAR(2)                               /* 40  役割         */
 , UNIQ        BIGINT                     NOT NULL      /* 800 ユニークキー */
 , FGJ         VARCHAR(1)     DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET       VARCHAR(14)                              /* 820 登録日時     */
 , PGSET       VARCHAR(10)                              /* 830 作成PG       */
 , PGPSET      VARCHAR(10)                              /* 840 作成親PG     */
 , USRSET      VARCHAR(10)                              /* 850 作成社員     */
 , DYUPD       VARCHAR(14)                              /* 860 更新日時     */
 , PGUPD       VARCHAR(10)                              /* 870 更新PG       */
 , PGPUPD      VARCHAR(10)                              /* 880 更新親PG     */
 , USRUPD      VARCHAR(10)                              /* 890 更新者       */
);

CREATE SEQUENCE GF65S00 ;


CREATE TRIGGER GF65T00 FOR GF65
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF65S00,1 );
  END; 


