/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.opengion.fukurou.util.DateSet;

public final class LogWriter {
    private static PrintWriter writer = null;
    private static String logFileUrl = null;

    private LogWriter() {
    }

    public static synchronized void init(String string) {
        logFileUrl = string;
    }

    public static synchronized void log(String string) {
        if (writer == null) {
            writer = LogWriter.getPrintWriter();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.JAPAN);
        writer.println("[WriteTime= " + simpleDateFormat.format(new Date()) + "] " + string);
        writer.flush();
    }

    public static synchronized void log(Throwable throwable) {
        if (writer == null) {
            writer = LogWriter.getPrintWriter();
        }
        throwable.printStackTrace(writer);
    }

    public static synchronized void close() {
        if (writer != null) {
            writer.close();
        }
        writer = null;
    }

    private static synchronized PrintWriter getPrintWriter() {
        if (logFileUrl == null || logFileUrl.length() == 0) {
            return new PrintWriter(System.err);
        }
        DateSet dateSet = new DateSet();
        logFileUrl = dateSet.changeString(logFileUrl);
        try {
            File file = new File(logFileUrl);
            return new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
        }
        catch (IOException iOException) {
            String string = "\u30ed\u30b0\u30e9\u30a4\u30bf\u30fc\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002[" + logFileUrl + "]";
            throw new RuntimeException(string, iOException);
        }
    }
}

