<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP03"
	title    = "レイアウトテーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここからです。 -->
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_CLM" value="COLUMN_NAME" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_CLM" value="CLM" />
</og:equals>

<!-- forward.jsp から command = "COPY" がセットされて遷移してくるので、複写画面となります。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}">
	<og:columnSet command = "{@command}" action = "ADD" columnId = "SEQ" />
	<og:columnSet command="{@command}" columnId="RDC_CODE"  action="SET"     value="{@USER.RDC_CODE}" />
</og:entry>

<!-- メッセージ表示を行います。必ずリソースファイルに表示するメッセージを登録し、 -->
<!-- lbl属性を使用して表示させて下さい。 -->
<og:message lbl="MSG0045" comment="複写処理を行います。" /><br />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />

</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType   = "HTMLTable"
	command        = "{@command}"
	columnWritable = "SYSTEM_ID,LISTID,KBTEXT,CLM,SEQ,USE_LENGTH,FGUSE,RELEASE_NOTES"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
/>

<og:hidden name="SQL" >
  <jsp:text>
	insert into GE52 (
		SYSTEM_ID,LISTID,KBTEXT,{@C_CLM},SEQ,USE_LENGTH,FGUSE,RELEASE_NOTES,
		FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD,RDC_CODE
	)
	values (
		[SYSTEM_ID],[LISTID],[KBTEXT],[CLM],[SEQ],[USE_LENGTH],[FGUSE],[RELEASE_NOTES],
		'1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}','{@USER.RDC_CODE}'
	)
  </jsp:text>
</og:hidden>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
