/**************************************************************************/
/* GF61 ( タイプ定義 )                                                    */
/*                                                                        */
/* Created : 2011/11/14 10:30:05                                          */
/**************************************************************************/
CREATE TABLE GF61 (
   IDTYPE  VARCHAR2(20)                 NOT NULL      /* 10  IDタイプ        */
 , NAME_JA VARCHAR2(200)                              /* 20  名称            */
 , DEFM1   VARCHAR2(30)                               /* 30  項目定義マスタ1 */
 , DEFM2   VARCHAR2(30)                               /* 40  項目定義マスタ2 */
 , DEFM3   VARCHAR2(30)                               /* 50  項目定義マスタ3 */
 , DEFM4   VARCHAR2(30)                               /* 60  項目定義マスタ4 */
 , DEFM5   VARCHAR2(30)                               /* 70  項目定義マスタ5 */
 , DEFM6   VARCHAR2(30)                               /* 80  項目定義マスタ6 */
 , UNIQ    NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー    */
 , FGJ     VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ      */
 , DYSET   VARCHAR2(14)                               /* 820 登録日時        */
 , PGSET   VARCHAR2(10)                               /* 830 作成PG          */
 , PGPSET  VARCHAR2(10)                               /* 840 作成親PG        */
 , USRSET  VARCHAR2(10)                               /* 850 作成社員        */
 , DYUPD   VARCHAR2(14)                               /* 860 更新日時        */
 , PGUPD   VARCHAR2(10)                               /* 870 更新PG          */
 , PGPUPD  VARCHAR2(10)                               /* 880 更新親PG        */
 , USRUPD  VARCHAR2(10)                               /* 890 更新者          */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF61S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF61T00 
BEFORE INSERT ON GF61
FOR EACH ROW 
BEGIN 
SELECT GF61S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

