/**************************************************************************/
/* GF93 ( 画面項目リンク )                                                */
/*                                                                        */
/* Created : 2011/11/14 10:30:05                                          */
/**************************************************************************/
CREATE TABLE GF93 (
   SYSTEM_ID   VARCHAR2(10)                               /* 10  システムID       */
 , PGID        VARCHAR2(30)                 NOT NULL      /* 20  PG-ID            */
 , NMSYORI     VARCHAR2(100)                              /* 30  処理グループ名   */
 , SEQ         NUMBER(7)        DEFAULT 0   NOT NULL      /* 40  順               */
 , CLM         VARCHAR2(30)                               /* 50  項目             */
 , TO_GAMENID  VARCHAR2(30)                               /* 60  先画面ID         */
 , HREF        VARCHAR2(256)                              /* 70  リンク先URL      */
 , TARGET      VARCHAR2(10)                               /* 80  ターゲット       */
 , P_KEYS      VARCHAR2(500)                              /* 90  引数キー         */
 , P_VALS      VARCHAR2(500)                              /* 100 引数値           */
 , USEGAMENID  VARCHAR2(10)                               /* 110 画面使用         */
 , USEREDIRECT VARCHAR2(10)                               /* 120 リダイレクト使用 */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 130 ユニークキー     */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 140 状態フラグ       */
 , DYSET       VARCHAR2(14)                               /* 150 登録日時         */
 , PGSET       VARCHAR2(10)                               /* 160 作成PG           */
 , PGPSET      VARCHAR2(10)                               /* 170 作成親PG         */
 , USRSET      VARCHAR2(10)                               /* 180 作成社員         */
 , DYUPD       VARCHAR2(14)                               /* 190 更新日時         */
 , PGUPD       VARCHAR2(10)                               /* 200 更新PG           */
 , PGPUPD      VARCHAR2(10)                               /* 210 更新親PG         */
 , USRUPD      VARCHAR2(10)                               /* 220 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF93S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF93T00 
BEFORE INSERT ON GF93
FOR EACH ROW 
BEGIN 
SELECT GF93S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

