/**************************************************************************/
/* GF64 ( タスクツリー )                                                  */
/*                                                                        */
/* Created : 2011/12/17 09:07:56                                          */
/**************************************************************************/
CREATE TABLE GF64 (
   PRJCODE      VARCHAR(30)                               /* 10  PRJコード         */
 , TASK_ID      NUMERIC(5)                                /* 20  タスクID          */
 , SEQ          NUMERIC(7)      DEFAULT 0   NOT NULL      /* 30  順                */
 , TASK_LEVEL   NUMERIC(2)                                /* 40  レベル            */
 , NAME_JA      VARCHAR(200)                              /* 50  名称              */
 , MEETING      VARCHAR(1)      DEFAULT '0'               /* 60  マイルストーン    */
 , DYSTART      VARCHAR(14)                               /* 70  開始日            */
 , DURATION     NUMERIC(4,1)                              /* 80  期間              */
 , COMPLETE     NUMERIC(3)                                /* 90  進捗率            */
 , PRIORITY     VARCHAR(1)                                /* 100 優先度            */
 , NOTES        BLOB                                      /* 110 ノート            */
 , COLOR        VARCHAR(7)                                /* 120 カラー            */
 , SHAPE        VARCHAR(16)                               /* 130 模様              */
 , DEPEND_ID1   NUMERIC(5)                                /* 140 DEPEND_ID1        */
 , DEPEND_TYPE1 VARCHAR(1)                                /* 150 先行タスクタイプ1 */
 , DEPEND_ID2   NUMERIC(5)                                /* 160 DEPEND_ID2        */
 , DEPEND_TYPE2 VARCHAR(1)                                /* 170 先行タスクタイプ2 */
 , DEPEND_ID3   NUMERIC(5)                                /* 180 DEPEND_ID3        */
 , DEPEND_TYPE3 VARCHAR(1)                                /* 190 先行タスクタイプ3 */
 , DEPEND_ID4   NUMERIC(5)                                /* 200 DEPEND_ID4        */
 , DEPEND_TYPE4 VARCHAR(1)                                /* 210 先行タスクタイプ4 */
 , DEPEND_ID5   NUMERIC(5)                                /* 220 DEPEND_ID5        */
 , DEPEND_TYPE5 VARCHAR(1)                                /* 230 先行タスクタイプ5 */
 , UNIQ         BIGINT                      NOT NULL      /* 800 ユニークキー      */
 , FGJ          VARCHAR(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ        */
 , DYSET        VARCHAR(14)                               /* 820 登録日時          */
 , PGSET        VARCHAR(10)                               /* 830 作成PG            */
 , PGPSET       VARCHAR(10)                               /* 840 作成親PG          */
 , USRSET       VARCHAR(10)                               /* 850 作成社員          */
 , DYUPD        VARCHAR(14)                               /* 860 更新日時          */
 , PGUPD        VARCHAR(10)                               /* 870 更新PG            */
 , PGPUPD       VARCHAR(10)                               /* 880 更新親PG          */
 , USRUPD       VARCHAR(10)                               /* 890 更新者            */
);

CREATE SEQUENCE GF64S00 ;


CREATE TRIGGER GF64T00 FOR GF64
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF64S00,1 );
  END; 


