<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:scriptlet>
	request.setCharacterEncoding("UTF-8"); 
</jsp:scriptlet>

<!-- イベント処理用のJSP内では、以下のパラメーターを使用することができます -->
<!-- *************************************************************************
	 * {@EC_CNAME}		子カラム名(一覧表示の場合でも行番号__nは付加されません)
	 * {@EC_RENDERER}	子カラムのレンデラー
	 * {@EC_EDITOR}		子カラムのエディター
	 * {@EC_SQL}		子カラムのプルダウン、または値を出力するためのSQL文({@xxx}をカラムのvalue値で置き換えたもの)
	 * {@EC_WRITABLE}	子カラムが編集可能などうか
	 * {@EC_CVALUE}		子カラムの現在の値
	 * {@EC_NOVALUE}	子カラムの最上部Option値が空ならtrue。その他false(addNoValue属性値と同じです) 
	 * {@EC_CLASS}		子カラムのCLASS属性
	 * {@EC_SIZE}		子カラムのSIZE属性
	 * {@EC_MAXLENGTH}	子カラムのMAXLENGTH属性
	 * {@EC_OPTATTRS}	子カラムのその他OPTION属性
	 * {@EC_PNAMEE}		親カラム名(一覧表示の場合でも行番号__nは付加されません)
	 * {@EC_PVALUE}		親カラムの現在の値
	 * ※なお、現時点ではINMENU,INDBMENUについては使用できません
	 ************************************************************************* -->

<!-- {@SYS.xxx}や{@USER.xxx}を変換 -->
<og:value command="SET" key="EC_SQL_PARSE" xssCheck="false">
	<og:text>{@EC_SQL}</og:text>
</og:value>

<!-- xxxDBMENUの場合にはパラメータにSQL文を与えてカラムを作成 -->
<og:equals val1="{@EC_EDITOR}" val2="DBMENU" endsWith="true" useStop="true">
	<og:column name="{@EC_CNAME}" editor="{@EC_EDITOR}" renderer="{@EC_RENDERER}" size="{@EC_SIZE}" maxlength="{@EC_MAXLENGTH}"
		writable="{@EC_WRITABLE}" td="false" clazz="{@EC_CLASS}" optionAttributes="{@EC_OPTATTRS}" xssCheck="false"
		param="{@EC_SQL_PARSE}" value="{@EC_CVALUE}" addNoValue="{@EC_NOVALUE}" />
</og:equals>

<!-- QUERYの場合もパラメータにSQL文を与えてカラムを作成 -->
<og:equals val1="{@EC_EDITOR}" val2="QUERY" useStop="true">
	<og:column name="{@EC_CNAME}" editor="{@EC_EDITOR}" renderer="{@EC_RENDERER}" size="{@EC_SIZE}" maxlength="{@EC_MAXLENGTH}"
		writable="{@EC_WRITABLE}" td="false" clazz="{@EC_CLASS}" optionAttributes="{@EC_OPTATTRS}" xssCheck="false"
		param="{@EC_SQL_PARSE}" />
</og:equals>

<!-- それ以外の場合はvalueにSQLのVALUEカラムの値を入れて作成 -->
<og:value command="SET" key="TMP_KEY" xssCheck="false">
<og:value command="SQLGET" xssCheck="false">
	{@EC_SQL_PARSE}
</og:value>
</og:value>
<og:column name="{@EC_CNAME}" editor="{@EC_EDITOR}" renderer="{@EC_RENDERER}" size="{@EC_SIZE}" maxlength="{@EC_MAXLENGTH}"
		writable="{@EC_WRITABLE}" td="false" clazz="{@EC_CLASS}" optionAttributes="{@EC_OPTATTRS}" xssCheck="false"
		value="{@TMP_KEY}" />

</jsp:root>

