<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2040"
	title	= "インデックスカラム"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,CLM,TABLE_NAME,INDEX_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.TBLSYU,A.TABLE_NAME,A.INDEX_NAME,A.CLM,A.SEQNO,
			B.NAME_JA,B.CLS_NAME,A.FGJ,A.SYSTEM_ID,A.UNIQ
		from GF07 A left outer join GF05 B
		on		A.SYSTEM_ID    = B.SYSTEM_ID
		and		A.TBLSYU       = B.TBLSYU
		and		A.TABLE_NAME   = B.TABLE_NAME
		and		A.CLM          = B.CLM
		and		A.FGJ          = B.FGJ
	</jsp:text>
	<og:where>
		<og:and value = "A.FGJ          in   ('0','1')"           />
		<og:and value = "A.SYSTEM_ID  =  '{@SYSTEM_ID}'"     />
		<og:and value = "A.TBLSYU       =    '{@TBLSYU}'"         />
		<og:and value = "A.TABLE_NAME   like '{@TABLE_NAME}%'"    />
		<og:and value = "A.CLM          like '{@CLM}%'"   />
		<og:and value = "A.INDEX_NAME   in  ( {@INDEX_NAME} )" multi="true" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.TBLSYU,A.TABLE_NAME,A.INDEX_NAME,A.SEQNO" />
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />

	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GF07" /></strong></legend>
		<og:submit  value="insertGF07" lbl="INSERT" command="INSERT" />
		<og:column  name="DBID"        size="5" td="no" />
		<og:column  name="TABLE_NAME"  size="5" td="no" />
		<og:column  name="TBLSYU" defaultVal="2" addNoValue="false" td="no" />
		<og:submit  value="directGF07" lbl="DIRECT" command="INSERT" />
	</fieldset>
	<og:hidden name="SYSTEM_ID" value="{@SYSTEM_ID}" />
	<br />
</og:writeCheck>
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
