<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="PRE_FIX"   select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
     <PRE_FIX   ><xsl:value-of select="$PRE_FIX"   /></PRE_FIX>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//og:link"    />
    <xsl:apply-templates select="//og:forward" />
    <xsl:apply-templates select="//og:submit"  />
  </xsl:template>

  <xsl:template match="og:link">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME     ><xsl:value-of select="name()"       /></TAGNAME>
       <TO_GAMENID  ><xsl:value-of select="@gamenId"     /></TO_GAMENID>
       <HREF        ><xsl:value-of select="@href"        /></HREF>
       <TARGET      ><xsl:value-of select="@target"      /></TARGET>
       <CLM         ><xsl:value-of select="@column"      /></CLM>
       <P_KEYS      ><xsl:value-of select="@keys"        /></P_KEYS>
       <P_VALS      ><xsl:value-of select="@vals"        /></P_VALS>
       <USEGAMENID  ><xsl:value-of select="@useGamenId"  /></USEGAMENID>
       <USEREDIRECT />
     </ROW>
  </xsl:template>

  <xsl:template match="og:forward">
     <xsl:if test="@gamenId | og:submit[starts-with( @page ,'../' )] | @useRedirect='true'">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME     ><xsl:value-of select="name()"       /></TAGNAME>
         <TO_GAMENID  ><xsl:value-of select="@gamenId"     /></TO_GAMENID>
         <HREF        ><xsl:value-of select="@page"        /></HREF>
         <TARGET      ><xsl:value-of select="@target"      /></TARGET>
         <CLM        />
         <P_KEYS      ><xsl:value-of select="@keys"        /></P_KEYS>
         <P_VALS      ><xsl:value-of select="@vals"        /></P_VALS>
         <USEGAMENID />
         <USEREDIRECT ><xsl:value-of select="@useRedirect" /></USEREDIRECT>
     </ROW>
     </xsl:if>
  </xsl:template>

  <xsl:template match="og:submit">
     <xsl:if test="@gamenId | og:submit[starts-with( @value ,'../' )]">
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME      ><xsl:value-of select="name()"  /></TAGNAME>
         <TO_GAMENID   ><xsl:value-of select="@gamenId"    /></TO_GAMENID>
         <HREF         ><xsl:value-of select="@value"      /></HREF>
         <TARGET       ><xsl:value-of select="@target"     /></TARGET>
         <CLM         />
         <P_KEYS       ><xsl:value-of select="@keys"       /></P_KEYS>
         <P_VALS       ><xsl:value-of select="@vals"       /></P_VALS>
         <USEGAMENID  />
         <USEREDIRECT />
     </ROW>
     </xsl:if>
  </xsl:template>

</xsl:stylesheet>
