/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import org.opengion.fukurou.mail.CharCodeConverter;
import org.opengion.fukurou.mail.UnicodeCorrecter;

class JISDataSource
implements DataSource {
    private final byte[] data;

    public JISDataSource(String string) {
        try {
            this.data = CharCodeConverter.sjisToJis(UnicodeCorrecter.correctToCP932(string).getBytes("Windows-31J"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "Windows-31J \u3067\u306e\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + string;
            throw new RuntimeException(string2, unsupportedEncodingException);
        }
    }

    public String getContentType() {
        return "text/plain; charset=ISO-2022-JP";
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new IOException(string);
    }

    public String getName() {
        return "JISDataSource";
    }
}

