/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import com.sun.media.jai.codec.FileSeekableStream;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;

public class ImageResizer {
    private static final long serialVersionUID = 5390L;
    private static final String ICC_PROFILE = "org/opengion/fukurou/util/ISOcoated_v2_eci.icc";
    private final File inFile;
    private final BufferedImage inputImage;
    private final int inSizeX;
    private final int inSizeY;

    public ImageResizer(String string) {
        BufferedImage bufferedImage;
        String string2 = ImageResizer.getSuffix(string);
        if ("|jpeg|jpg|png|gif|".indexOf(string2) < 0) {
            String string3 = "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306f(JPEG|PNG|GIF)\u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u306e\u307f\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002File=[" + string + "]";
            throw new RuntimeException(string3);
        }
        this.inFile = new File(string);
        try {
            bufferedImage = ImageIO.read(this.inFile);
        }
        catch (IIOException iIOException) {
            FileSeekableStream fileSeekableStream = null;
            try {
                fileSeekableStream = new FileSeekableStream(this.inFile.getAbsolutePath());
                bufferedImage = this.cmykToSRGB(JAI.create((String)"stream", (Object)fileSeekableStream).getAsBufferedImage(null, null));
            }
            catch (IOException iOException) {
                try {
                    String string4 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc(JAI)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
                    throw new RuntimeException(string4, iOException);
                }
                catch (Throwable throwable) {
                    Closer.ioClose(fileSeekableStream);
                    throw throwable;
                }
            }
            Closer.ioClose((Closeable)fileSeekableStream);
        }
        catch (IOException iOException) {
            String string5 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
            throw new RuntimeException(string5, iOException);
        }
        this.inputImage = bufferedImage;
        this.inSizeX = this.inputImage.getWidth();
        this.inSizeY = this.inputImage.getHeight();
    }

    public void resizeByPixel(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.inSizeX > this.inSizeY) {
            n2 = n;
            n3 = this.inSizeY * n / this.inSizeX;
        } else {
            n2 = this.inSizeX * n / this.inSizeY;
            n3 = n;
        }
        this.convert(this.inputImage, string, n2, n3);
    }

    public void resizeByPixel(String string, int n, int n2) {
        this.convert(this.inputImage, string, n, n2);
    }

    public void resizeByRatio(String string, double d) {
        int n = (int)((double)this.inSizeX * d);
        int n2 = (int)((double)this.inSizeY * d);
        this.convert(this.inputImage, string, n, n2);
    }

    private void convert(BufferedImage bufferedImage, String string, int n, int n2) {
        String string2 = ImageResizer.getSuffix(string);
        if ("|jpeg|jpg|png|".indexOf(string2) < 0) {
            String string3 = "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306f(JPEG|PNG)\u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u306e\u307f\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002File=[" + string + "]";
            throw new RuntimeException(string3);
        }
        File file = new File(string);
        if (n > this.inSizeX && n2 > this.inSizeY) {
            FileUtil.copy(this.inFile, file);
            return;
        }
        int n3 = bufferedImage.getType();
        BufferedImage bufferedImage2 = null;
        bufferedImage2 = n3 == 0 ? new BufferedImage(n, n2, 7) : new BufferedImage(n, n2, bufferedImage.getType());
        AffineTransformOp affineTransformOp = null;
        affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance((double)n / (double)this.inSizeX, (double)n2 / (double)this.inSizeY), null);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        try {
            ImageIO.write((RenderedImage)bufferedImage2, string2, file);
        }
        catch (IOException iOException) {
            String string4 = "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002File=[" + string + "]";
            throw new RuntimeException(string4, iOException);
        }
    }

    private static String getSuffix(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.lastIndexOf(46)) >= 0 && (string2 = string.substring(n + 1).toLowerCase(Locale.JAPAN)).length() > 5) {
            string2 = null;
        }
        return string2;
    }

    public BufferedImage cmykToSRGB(BufferedImage bufferedImage) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(ICC_PROFILE);
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(inputStream);
        ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        ColorSpace colorSpace = bufferedImage2.getColorModel().getColorSpace();
        ColorConvertOp colorConvertOp = new ColorConvertOp(iCC_ColorSpace, colorSpace, null);
        colorConvertOp.filter(bufferedImage, bufferedImage2);
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = bufferedImage2.getRGB(i, j);
                int n4 = (n3 & 0xFF0000) >> 16;
                int n5 = (n3 & 0xFF00) >> 8;
                int n6 = n3 & 0xFF;
                n3 = (Math.abs(n4 - 255) << 16) + (Math.abs(n5 - 255) << 8) + Math.abs(n6 - 255);
                bufferedImage2.setRGB(i, j, n3);
            }
        }
        return bufferedImage2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.ImageResizer [Input Filename] [OutputFilename] [ResizeScale]");
            return;
        }
        ImageResizer imageResizer = new ImageResizer(stringArray[0]);
        imageResizer.resizeByPixel(stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[2]));
    }
}

