/**************************************************************************/
/* GE62 ( 伝送定義マスタ )                                                */
/*                                                                        */
/* Created : 2012/01/25 19:01:58                                          */
/**************************************************************************/
CREATE TABLE GE62 (
   SYSTEM_ID    VARCHAR2(10)                 NOT NULL      /* 10  システムID       */
 , KBREAD       VARCHAR2(20)                 NOT NULL      /* 20  読取方法         */
 , READOBJ      VARCHAR2(200)                NOT NULL      /* 30  読取対象         */
 , READPRM      VARCHAR2(200)                              /* 40  読取パラメーター */
 , KBEXEC       VARCHAR2(20)                 NOT NULL      /* 50  実行方法         */
 , EXECDBID     VARCHAR2(100)                              /* 60  実行DB接続先ID   */
 , EXECOBJ      VARCHAR2(200)                NOT NULL      /* 70  実行対象         */
 , EXECPRM      VARCHAR2(200)                              /* 80  実行パラメーター */
 , DMN_GRP      VARCHAR2(20)                 NOT NULL      /* 90  デーモングループ */
 , DMN_TIME     NUMBER(6)        DEFAULT 60  NOT NULL      /* 100 デーモン周期     */
 , ERROR_SENDTO VARCHAR2(200)                              /* 110 エラー送信先     */
 , UNIQ         NUMBER(9)        DEFAULT 0   NOT NULL      /* 120 ユニークキー     */
 , FGJ          VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 130 状態フラグ       */
 , DYSET        VARCHAR2(14)                               /* 140 登録日時         */
 , PGSET        VARCHAR2(10)                               /* 150 作成PG           */
 , PGPSET       VARCHAR2(10)                               /* 160 作成親PG         */
 , USRSET       VARCHAR2(10)                               /* 170 作成社員         */
 , DYUPD        VARCHAR2(14)                               /* 180 更新日時         */
 , PGUPD        VARCHAR2(10)                               /* 190 更新PG           */
 , PGPUPD       VARCHAR2(10)                               /* 200 更新親PG         */
 , USRUPD       VARCHAR2(10)                               /* 210 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE62S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE62T00 
BEFORE INSERT ON GE62
FOR EACH ROW 
BEGIN 
SELECT GE62S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

