/**************************************************************************/
/* GEA09 ( ユーザーアクセス画面管理テーブル )                             */
/*                                                                        */
/* Created : 2012/01/25 19:01:58                                          */
/**************************************************************************/
CREATE TABLE GEA09 (
   SYSTEM_ID   VARCHAR2(10)                  NOT NULL      /* 10  システムID       */
 , USERID      VARCHAR2(10)                  NOT NULL      /* 20  ユーザーID       */
 , GUIKEY      VARCHAR2(30)                  NOT NULL      /* 30  画面ID           */
 , SEQNO       NUMBER(7)         DEFAULT 0   NOT NULL      /* 40  表示順           */
 , NAME_JA     VARCHAR2(200)                               /* 50  名称             */
 , LAST_ACCESS VARCHAR2(14)                                /* 60  最終アクセス時間 */
 , FGFAVORITE  VARCHAR2(1)                                 /* 70  お気に入り       */
 , CLASSIFY    VARCHAR2(120)                               /* 80  分類             */
 , NEXTGUI     VARCHAR2(1000)                              /* 90  次画面リスト     */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 100 ユニークキー     */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 110 状態フラグ       */
 , DYSET       VARCHAR2(14)                                /* 120 登録日時         */
 , PGSET       VARCHAR2(10)                                /* 130 作成PG           */
 , PGPSET      VARCHAR2(10)                                /* 140 作成親PG         */
 , USRSET      VARCHAR2(10)                                /* 150 作成社員         */
 , DYUPD       VARCHAR2(14)                                /* 160 更新日時         */
 , PGUPD       VARCHAR2(10)                                /* 170 更新PG           */
 , PGPUPD      VARCHAR2(10)                                /* 180 更新親PG         */
 , USRUPD      VARCHAR2(10)                                /* 190 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 128K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GEA09S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA09T00 
BEFORE INSERT ON GEA09
FOR EACH ROW 
BEGIN 
SELECT GEA09S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

