/**************************************************************************/
/* GF05 ( テーブルカラム定義 )                                            */
/*                                                                        */
/* Created : 2012/01/25 19:01:59                                          */
/**************************************************************************/
CREATE TABLE GF05 (
   SYSTEM_ID    VARCHAR2(10)                  NOT NULL      /* 10  システムID   */
 , TBLSYU       VARCHAR2(1)                   NOT NULL      /* 20  テーブル種別 */
 , TABLE_NAME   VARCHAR2(50)                  NOT NULL      /* 30  テーブル名   */
 , CLM          VARCHAR2(30)                  NOT NULL      /* 40  項目         */
 , SEQNO        NUMBER(7)         DEFAULT 0   NOT NULL      /* 50  表示順       */
 , NAME_JA      VARCHAR2(200)                               /* 60  名称         */
 , CLS_NAME     VARCHAR2(10)                  NOT NULL      /* 70  DBクラス     */
 , USE_LENGTH   VARCHAR2(9)       DEFAULT '0' NOT NULL      /* 80  使用桁数     */
 , DATA_DEFAULT VARCHAR2(30)                                /* 90  初期値       */
 , NOT_NULL     VARCHAR2(1)                                 /* 100 NOT NULL     */
 , FGCOM        VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 110 共通項目F    */
 , RENDERER     VARCHAR2(10)                                /* 120 表示種別     */
 , EDITOR       VARCHAR2(10)                                /* 130 編集種別     */
 , DBTYPE       VARCHAR2(10)                                /* 140 文字種別     */
 , BIKO         VARCHAR2(2000)                              /* 150 備考         */
 , CDKH         VARCHAR2(1)                                 /* 160 改廃コード   */
 , UNIQ         NUMBER(9)         DEFAULT 0   NOT NULL      /* 170 ユニークキー */
 , FGJ          VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 180 状態フラグ   */
 , DYSET        VARCHAR2(14)                                /* 190 登録日時     */
 , PGSET        VARCHAR2(10)                                /* 200 作成PG       */
 , PGPSET       VARCHAR2(10)                                /* 210 作成親PG     */
 , USRSET       VARCHAR2(10)                                /* 220 作成社員     */
 , DYUPD        VARCHAR2(14)                                /* 230 更新日時     */
 , PGUPD        VARCHAR2(10)                                /* 240 更新PG       */
 , PGPUPD       VARCHAR2(10)                                /* 250 更新親PG     */
 , USRUPD       VARCHAR2(10)                                /* 260 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 5120K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF05S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF05T00 
BEFORE INSERT ON GF05
FOR EACH ROW 
BEGIN 
SELECT GF05S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

