/**************************************************************************/
/* GEA05 ( ロールマスタ )                                                 */
/*                                                                        */
/* Created : 2012/02/01 17:06:07                                          */
/**************************************************************************/
CREATE TABLE GEA05 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , ROLES     VARCHAR2(500)                NOT NULL      /* 20  ロールズ     */
 , NMROLE    VARCHAR2(200)                              /* 30  ロール名称   */
 , KBROLE    VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 40  ロール区分   */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 50  ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 60  状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 70  登録日時     */
 , PGSET     VARCHAR2(10)                               /* 80  作成PG       */
 , PGPSET    VARCHAR2(10)                               /* 90  作成親PG     */
 , USRSET    VARCHAR2(10)                               /* 100 作成社員     */
 , DYUPD     VARCHAR2(14)                               /* 110 更新日時     */
 , PGUPD     VARCHAR2(10)                               /* 120 更新PG       */
 , PGPUPD    VARCHAR2(10)                               /* 130 更新親PG     */
 , USRUPD    VARCHAR2(10)                               /* 140 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GEA05S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA05T00 
BEFORE INSERT ON GEA05
FOR EACH ROW 
BEGIN 
SELECT GEA05S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

