/**************************************************************************/
/* GF66 ( タスクリソース定義 )                                            */
/*                                                                        */
/* Created : 2012/02/01 17:06:19                                          */
/**************************************************************************/
CREATE TABLE GF66 (
   PRJCODE     VARCHAR(30)                              /* 10  PRJコード    */
 , TASK_ID     NUMERIC(5)                               /* 20  タスクID     */
 , RESOURCE_ID NUMERIC(9)                               /* 30  リソースID   */
 , SEQ         NUMERIC(7)     DEFAULT 0   NOT NULL      /* 40  順           */
 , SU_LOAD     NUMERIC(5)                               /* 50  負荷         */
 , UNIQ        BIGINT                     NOT NULL      /* 800 ユニークキー */
 , FGJ         VARCHAR(1)     DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET       VARCHAR(14)                              /* 820 登録日時     */
 , PGSET       VARCHAR(10)                              /* 830 作成PG       */
 , PGPSET      VARCHAR(10)                              /* 840 作成親PG     */
 , USRSET      VARCHAR(10)                              /* 850 作成社員     */
 , DYUPD       VARCHAR(14)                              /* 860 更新日時     */
 , PGUPD       VARCHAR(10)                              /* 870 更新PG       */
 , PGPUPD      VARCHAR(10)                              /* 880 更新親PG     */
 , USRUPD      VARCHAR(10)                              /* 890 更新者       */
);

CREATE SEQUENCE GF66S00 ;


CREATE TRIGGER GF66T00 FOR GF66
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF66S00,1 );
  END; 


