/**************************************************************************/
/* GF27 ( 逆引きマニュアル )                                              */
/*                                                                        */
/* Created : 2012/02/01 17:06:08                                          */
/**************************************************************************/
CREATE TABLE GF27 (
   SEQ          NUMBER(7)         DEFAULT 0   NOT NULL      /* 10  順           */
 , TITLE        VARCHAR2(300)                 NOT NULL      /* 20  タイトル     */
 , ANSWER       VARCHAR2(200)                               /* 30  回答         */
 , DIFFICULTY   VARCHAR2(1)                                 /* 40  難易度       */
 , PARTNO       NUMBER(2)                                   /* 50  部番号       */
 , PART         VARCHAR2(100)                               /* 60  部           */
 , CHAPTERNO    NUMBER(2)                                   /* 70  章番号       */
 , CHAPTER      VARCHAR2(100)                               /* 80  章           */
 , BIG_CLASS    VARCHAR2(100)                               /* 90  大分類       */
 , INSIDE_CLASS VARCHAR2(100)                               /* 100 中分類       */
 , KEYWORD      VARCHAR2(200)                               /* 110 キーワード   */
 , CONTENTS     CLOB                                        /* 120 内容         */
 , SAMPLE       VARCHAR2(4000)                              /* 130 サンプル     */
 , URL          VARCHAR2(200)                               /* 140 URL          */
 , UNIQ         NUMBER(9)         DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ          VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET        VARCHAR2(14)                                /* 820 登録日時     */
 , PGSET        VARCHAR2(10)                                /* 830 作成PG       */
 , PGPSET       VARCHAR2(10)                                /* 840 作成親PG     */
 , USRSET       VARCHAR2(10)                                /* 850 作成社員     */
 , DYUPD        VARCHAR2(14)                                /* 860 更新日時     */
 , PGUPD        VARCHAR2(10)                                /* 870 更新PG       */
 , PGPUPD       VARCHAR2(10)                                /* 880 更新親PG     */
 , USRUPD       VARCHAR2(10)                                /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 128K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF27S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF27T00 
BEFORE INSERT ON GF27
FOR EACH ROW 
BEGIN 
SELECT GF27S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

