/**************************************************************************/
/* GF75 ( JavaScript状態テーブル )                                        */
/*                                                                        */
/* Created : 2012/02/01 17:06:08                                          */
/**************************************************************************/
CREATE TABLE GF75 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID           */
 , PRE_FIX   VARCHAR2(10)                 NOT NULL      /* 20  名前空間             */
 , ADDRESS   VARCHAR2(256)                              /* 30  アドレス             */
 , FILENAME  VARCHAR2(60)                               /* 40  ファイル名           */
 , FILEPATH  VARCHAR2(256)                              /* 50  ファイルパス         */
 , MODIFIED  VARCHAR2(14)                               /* 60  最終更新日           */
 , TAGNAME   VARCHAR2(30)                               /* 70  タグ名称             */
 , SRC_FILE  VARCHAR2(250)                              /* 80  インクルードファイル */
 , FGOMIT    VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 90  除外フラグ           */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 100 ユニークキー         */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 110 状態フラグ           */
 , DYSET     VARCHAR2(14)                               /* 120 登録日時             */
 , PGSET     VARCHAR2(10)                               /* 130 作成PG               */
 , PGPSET    VARCHAR2(10)                               /* 140 作成親PG             */
 , USRSET    VARCHAR2(10)                               /* 150 作成社員             */
 , DYUPD     VARCHAR2(14)                               /* 160 更新日時             */
 , PGUPD     VARCHAR2(10)                               /* 170 更新PG               */
 , PGPUPD    VARCHAR2(10)                               /* 180 更新親PG             */
 , USRUPD    VARCHAR2(10)                               /* 190 更新者               */
)
TABLESPACE GETBL01
STORAGE( INITIAL 320K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF75S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF75T00 
BEFORE INSERT ON GF75
FOR EACH ROW 
BEGIN 
SELECT GF75S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

