/**************************************************************************/
/* GEA08 ( 項目名称定義（ラベル） )                                       */
/*                                                                        */
/* Created : 2012/03/02 18:46:48                                          */
/**************************************************************************/
CREATE TABLE GEA08 (
   SYSTEM_ID     VARCHAR(10)                 NOT NULL      /* 10  システムID     */
 , LANG          VARCHAR(2)                  NOT NULL      /* 20  言語           */
 , CLM           VARCHAR(30)                 NOT NULL      /* 30  項目           */
 , NAME_JA       VARCHAR(200)                              /* 40  名称           */
 , SNAME         VARCHAR(60)                               /* 50  名前(短)       */
 , LNAME         VARCHAR(500)                              /* 60  名前(長)       */
 , COMMENTS      VARCHAR(500)                              /* 70  コメント       */
 , CDKH          VARCHAR(1)                                /* 80  改廃コード     */
 , FGLOAD        VARCHAR(1)      DEFAULT '0' NOT NULL      /* 90  読込F          */
 , KBSAKU        VARCHAR(1)      DEFAULT '1' NOT NULL      /* 100 作成区分       */
 , RELEASE_NOTES VARCHAR(120)                              /* 180 リリースノート */
 , RDC_CODE      VARCHAR(20)                               /* 190 設変番号       */
 , DESCRIPTION   BLOB                                      /* 200 概要説明       */
 , KBLBL         VARCHAR(1)                  NOT NULL      /* 210 ラベル区分     */
 , UNIQ          BIGINT                      NOT NULL      /* 800 ユニークキー   */
 , FGJ           VARCHAR(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ     */
 , DYSET         VARCHAR(14)                               /* 820 登録日時       */
 , PGSET         VARCHAR(10)                               /* 830 作成PG         */
 , PGPSET        VARCHAR(10)                               /* 840 作成親PG       */
 , USRSET        VARCHAR(10)                               /* 850 作成社員       */
 , DYUPD         VARCHAR(14)                               /* 860 更新日時       */
 , PGUPD         VARCHAR(10)                               /* 870 更新PG         */
 , PGPUPD        VARCHAR(10)                               /* 880 更新親PG       */
 , USRUPD        VARCHAR(10)                               /* 890 更新者         */
);

CREATE SEQUENCE GEA08S00 ;


CREATE TRIGGER GEA08T00 FOR GEA08
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GEA08S00,1 );
  END; 


