<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL07"
	title	= "バッチデータ検索・再送"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_H_TXT" value="HEADER" />
	<og:value command="SET" key="C_F_TXT" value="FOOTER" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_H_TXT" value="H_TXT" />
	<og:value command="SET" key="C_F_TXT" value="F_TXT" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" stopZero="true">
		SELECT	 FGJ FGJ_PARA
				,decode( FGJ, '2', 1, 0 ) LINK_RRK
				,UNIQ
				,DYSET
				,USRSET
				,PGUPD
				,SYSTEM_ID
				,PTN_ID
				,FROM_ID
				,TO_ID
				,CC_ID
				,BCC_ID
				,{@C_H_TXT} H_TXT
				,{@C_F_TXT} F_TXT
				,PARAM0
				,PARAM1
				,PARAM2
				,PARAM3
				,PARAM4
				,PARAM5
				,PARAM6
				,PARAM7
				,PARAM8
				,PARAM9
				,ATTACH1
				,ATTACH2
				,ATTACH3
				,ATTACH4
				,ATTACH5
				,DECODE((SELECT COUNT(*) FROM GE36 WHERE PARA_KEY=GE30.UNIQ),0,0,1) LINK_ERR
		FROM	GE30
	<og:where>
		<og:and value = "SYSTEM_ID 	=	 '{@SYSTEM_ID}'" />
		<og:and value = "FROM_ID 		=	 '{@FROM_ID}'"   />
		<og:and value = "PTN_ID 		=	 '{@PTN_ID}'"    />
		<og:and value = "UNIQ	 		=	 '{@UNIQ}'"      />
		<og:and value = "PGUPD	 	=	 '{@PGUPD}'"    />
		<og:and value = "USRSET	 	=	 '{@USRSET}'"    />
		<og:and value = "COALESCE(FGJ,'0')	=	 '{@FGJ_PARA}'"  />
		<og:and value = "DYSET			&gt;= '{@DYSET_FROM}'"/>
		<og:and value = "DYSET			&lt;= '{@DYSET_TO}'"  />
	</og:where>
	<og:appear startKey = "ORDER BY" value = "UNIQ" />
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<og:writeCheck>
	<og:submit value="modify" command="MODIFY" lbl="MODIFY" accesskey="M" />
<br />
</og:writeCheck>

<og:viewLink command="{@command}" >
	<og:link onLink="[LINK_RRK]" column="FGJ_PARA" gamenId="MAIL03" target="CONTENTS" useGamenId="true"
		keys="command,SYSTEM_ID,PARA_KEY" vals="NEW,[SYSTEM_ID],[UNIQ]" />
	<og:link onLink="[LINK_ERR]" column="UNIQ" gamenId="MAIL06" target="CONTENTS" useGamenId="true"
		keys="command,SYSTEM_ID,PARA_KEY" vals="NEW,[SYSTEM_ID],[UNIQ]" />
</og:viewLink>

<og:columnEditor column="TO_ID" renderer="SLABEL" />
<og:columnEditor column="CC_ID" renderer="SLABEL" />
<og:columnEditor column="BCC_ID" renderer="SLABEL" />

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "LINK_RRK,LINK_ERR"
	selectedType = "checkbox"/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
