/**************************************************************************/
/* GEA11 ( 画面定義 )                                                     */
/*                                                                        */
/* Created : 2012/03/27 19:47:12                                          */
/**************************************************************************/
CREATE TABLE GEA11 (
   SYSTEM_ID     VARCHAR2(10)                 NOT NULL      /* 10  システムID     */
 , SEQNO         NUMBER(7)        DEFAULT 0   NOT NULL      /* 20  表示順         */
 , GUIKEY        VARCHAR2(30)                 NOT NULL      /* 30  画面ID         */
 , NAME_JA       VARCHAR2(200)                              /* 40  名称           */
 , GUILVL        VARCHAR2(1)      DEFAULT '3' NOT NULL      /* 50  画面Lv         */
 , ADDRESS       VARCHAR2(256)                              /* 60  アドレス       */
 , ROLES         VARCHAR2(500)                              /* 70  ロールズ       */
 , RWMODE        VARCHAR2(3)                                /* 80  モード         */
 , TARGET        VARCHAR2(10)                               /* 90  ターゲット     */
 , PARAM         VARCHAR2(500)                              /* 100 設定値         */
 , CDKH          VARCHAR2(1)                                /* 110 改廃コード     */
 , KBSAKU        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 120 作成区分       */
 , RELEASE_NOTES VARCHAR2(120)                              /* 130 リリースノート */
 , RDC_CODE      VARCHAR2(20)                               /* 140 設変番号       */
 , GROUPS        VARCHAR2(500)                              /* 150 グループス     */
 , LABEL_CLM     VARCHAR2(30)                               /* 160 ラベルカラム   */
 , COMMENTS      VARCHAR2(500)                              /* 170 コメント       */
 , KBLINK        VARCHAR2(10)                               /* 180 リンク区分     */
 , UNIQ          NUMBER(9)        DEFAULT 0   NOT NULL      /* 190 ユニークキー   */
 , FGJ           VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 200 状態フラグ     */
 , DYSET         VARCHAR2(14)                               /* 210 登録日時       */
 , PGSET         VARCHAR2(10)                               /* 220 作成PG         */
 , PGPSET        VARCHAR2(10)                               /* 230 作成親PG       */
 , USRSET        VARCHAR2(10)                               /* 240 作成社員       */
 , DYUPD         VARCHAR2(14)                               /* 250 更新日時       */
 , PGUPD         VARCHAR2(10)                               /* 260 更新PG         */
 , PGPUPD        VARCHAR2(10)                               /* 270 更新親PG       */
 , USRUPD        VARCHAR2(10)                               /* 280 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 192K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GEA11S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA11T00 
BEFORE INSERT ON GEA11
FOR EACH ROW 
BEGIN 
SELECT GEA11S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

