/**************************************************************************/
/* GE20 ( ユーザーロール設定値テーブル )                                  */
/*                                                                        */
/* Created : 2012/04/16 15:51:04                                          */
/**************************************************************************/
CREATE TABLE GE20 (
   SYSTEM_ID VARCHAR(10)                 NOT NULL      /* 10  システムID   */
 , USERID    VARCHAR(10)                 NOT NULL      /* 20  ユーザーID   */
 , ROLES     VARCHAR(500)                NOT NULL      /* 30  ロールズ     */
 , PARAM_ID  VARCHAR(50)                 NOT NULL      /* 40  パラメータID */
 , PARAM     BLOB                                      /* 50  設定値       */
 , KBSET     VARCHAR(1)      DEFAULT '0' NOT NULL      /* 60  設定区分     */
 , UNIQ      BIGINT                      NOT NULL      /* 70  ユニークキー */
 , FGJ       VARCHAR(1)      DEFAULT '1' NOT NULL      /* 80  状態フラグ   */
 , DYSET     VARCHAR(14)                               /* 90  登録日時     */
 , PGSET     VARCHAR(10)                               /* 100 作成PG       */
 , PGPSET    VARCHAR(10)                               /* 110 作成親PG     */
 , USRSET    VARCHAR(10)                               /* 120 作成社員     */
 , DYUPD     VARCHAR(14)                               /* 130 更新日時     */
 , PGUPD     VARCHAR(10)                               /* 140 更新PG       */
 , PGPUPD    VARCHAR(10)                               /* 150 更新親PG     */
 , USRUPD    VARCHAR(10)                               /* 160 更新者       */
);

CREATE SEQUENCE GE20S00 ;


CREATE TRIGGER GE20T00 FOR GE20
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GE20S00,1 );
  END; 


