/**************************************************************************/
/* GF90 ( 青紙テーブル )                                                  */
/*                                                                        */
/* Created : 2012/04/16 15:51:04                                          */
/**************************************************************************/
CREATE TABLE GF90 (
   SYSTEM_ID VARCHAR(10)                 NOT NULL      /* 10  システムID   */
 , NMSYS     VARCHAR(200)                              /* 20  システム名   */
 , PGID      VARCHAR(30)                 NOT NULL      /* 30  PG-ID        */
 , SEQ       NUMERIC(7)      DEFAULT 0   NOT NULL      /* 40  順           */
 , NMPG      VARCHAR(200)                              /* 50  処理名       */
 , PGLANG    VARCHAR(10)                               /* 60  言語         */
 , SIYOSAKU  VARCHAR(10)                               /* 70  仕様作成者   */
 , PGSAKU    VARCHAR(10)                               /* 80  PG作成者     */
 , PGKEN     VARCHAR(10)                               /* 90  検証者       */
 , DYSAKU    VARCHAR(8)                                /* 100 作成日       */
 , DYKAN     VARCHAR(8)                                /* 110 完成日       */
 , DYKEN     VARCHAR(8)                                /* 120 検証日       */
 , CDSAKU    VARCHAR(30)                               /* 130 作番CD       */
 , GUITYPE   VARCHAR(2)                                /* 140 画面タイプ   */
 , HPGID     VARCHAR(30)                               /* 150 雛形PGID     */
 , SPGID     VARCHAR(30)                               /* 160 参照PGID     */
 , FGGAMEN   VARCHAR(1)                                /* 170 画面編集FG   */
 , GAIYO     BLOB                                      /* 180 処理概要     */
 , UNIQ      BIGINT                      NOT NULL      /* 190 ユニークキー */
 , FGJ       VARCHAR(1)      DEFAULT '1' NOT NULL      /* 200 状態フラグ   */
 , DYSET     VARCHAR(14)                               /* 210 登録日時     */
 , PGSET     VARCHAR(10)                               /* 220 作成PG       */
 , PGPSET    VARCHAR(10)                               /* 230 作成親PG     */
 , USRSET    VARCHAR(10)                               /* 240 作成社員     */
 , DYUPD     VARCHAR(14)                               /* 250 更新日時     */
 , PGUPD     VARCHAR(10)                               /* 260 更新PG       */
 , PGPUPD    VARCHAR(10)                               /* 270 更新親PG     */
 , USRUPD    VARCHAR(10)                               /* 280 更新者       */
);

CREATE SEQUENCE GF90S00 ;


CREATE TRIGGER GF90T00 FOR GF90
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF90S00,1 );
  END; 


