/**************************************************************************/
/* GF82 ( DBオブジェクト一覧テーブル )                                    */
/*                                                                        */
/* Created : 2012/04/16 15:50:52                                          */
/**************************************************************************/
CREATE TABLE GF82 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID         */
 , TBLSYU    VARCHAR2(1)                  NOT NULL      /* 20  テーブル種別       */
 , OBJ_TYPE  VARCHAR2(20)                 NOT NULL      /* 30  オブジェクトタイプ */
 , OBJ_NAME  VARCHAR2(30)                 NOT NULL      /* 40  オブジェクト名     */
 , NAME_JA   VARCHAR2(200)                              /* 50  名称               */
 , STTS      VARCHAR2(7)                                /* 60  ステータス         */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー       */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ         */
 , DYSET     VARCHAR2(14)                               /* 820 登録日時           */
 , PGSET     VARCHAR2(10)                               /* 830 作成PG             */
 , PGPSET    VARCHAR2(10)                               /* 840 作成親PG           */
 , USRSET    VARCHAR2(10)                               /* 850 作成社員           */
 , DYUPD     VARCHAR2(14)                               /* 860 更新日時           */
 , PGUPD     VARCHAR2(10)                               /* 870 更新PG             */
 , PGPUPD    VARCHAR2(10)                               /* 880 更新親PG           */
 , USRUPD    VARCHAR2(10)                               /* 890 更新者             */
)
TABLESPACE GETBL01
STORAGE( INITIAL 128K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF82S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF82T00 
BEFORE INSERT ON GF82
FOR EACH ROW 
BEGIN 
SELECT GF82S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

