/**************************************************************************/
/* GF92 ( 画面項目定義テーブル )                                          */
/*                                                                        */
/* Created : 2012/04/16 15:50:52                                          */
/**************************************************************************/
CREATE TABLE GF92 (
   SYSTEM_ID   VARCHAR2(10)                               /* 10  システムID     */
 , PGID        VARCHAR2(30)                 NOT NULL      /* 20  PG-ID          */
 , NMSYORI     VARCHAR2(100)                              /* 30  処理グループ名 */
 , SEQ         NUMBER(7)        DEFAULT 0   NOT NULL      /* 40  順             */
 , CLM         VARCHAR2(30)                               /* 50  項目           */
 , KBACCS      VARCHAR2(1)                                /* 60  アクセス区分   */
 , USE_ORDER   VARCHAR2(1)                                /* 70  表示順指定     */
 , AS_CLM      VARCHAR2(30)                               /* 80  カラム別名     */
 , JOINTYPE    VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 90  連携タイプ     */
 , CLS_NAME    VARCHAR2(10)                               /* 100 DBクラス       */
 , MUST        VARCHAR2(10)                               /* 110 必須           */
 , DEFAULT_VAL VARCHAR2(100)                              /* 120 デフォルト値   */
 , TABLE_NAME  VARCHAR2(50)                 NOT NULL      /* 130 テーブル名     */
 , AS_TABLE    VARCHAR2(2)                  NOT NULL      /* 140 テーブル別名   */
 , ZOKUSEI     VARCHAR2(500)                              /* 150 属性           */
 , SETU        VARCHAR2(500)                              /* 160 項目説明       */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 170 ユニークキー   */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 180 状態フラグ     */
 , DYSET       VARCHAR2(14)                               /* 190 登録日時       */
 , PGSET       VARCHAR2(10)                               /* 200 作成PG         */
 , PGPSET      VARCHAR2(10)                               /* 210 作成親PG       */
 , USRSET      VARCHAR2(10)                               /* 220 作成社員       */
 , DYUPD       VARCHAR2(14)                               /* 230 更新日時       */
 , PGUPD       VARCHAR2(10)                               /* 240 更新PG         */
 , PGPUPD      VARCHAR2(10)                               /* 250 更新親PG       */
 , USRUPD      VARCHAR2(10)                               /* 260 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF92S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF92T00 
BEFORE INSERT ON GF92
FOR EACH ROW 
BEGIN 
SELECT GF92S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

