<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2000"
	title	= "テーブルスペース"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "TABLESPACE_NAME,SYSTEM_ID,TBLSYU,NAME_JA"
/>

<og:entry command = "{@command}" />

<table><tr><td>
<og:chartCreate
	title		= "{@LBL.TABLESPACE_NAME}"
	width		= "300"
	height		= "200"
>
	<og:chartDataset
		chartType	= "Pie"
	>
		<jsp:text>
			select TABLESPACE_NAME,
					SUM(INITIAL_AUTO) AS KEI
			from GF02
		</jsp:text>
		<og:where>
			<og:and value = "FGJ             in  ('0','1')"              />
			<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"       />
			<og:and value = "TBLSYU          like '{@TBLSYU}%'"          />
			<og:and value = "TABLESPACE_NAME like '{@TABLESPACE_NAME}%'" />
		</og:where>
		<jsp:text>
			group by TABLESPACE_NAME
			order by TABLESPACE_NAME
		</jsp:text>
	</og:chartDataset>
</og:chartCreate>
</td><td>
<og:chartCreate
	title		= "{@LBL.TABLESPACE_NAME}"
	width		= "300"
	height		= "200"
>
	<og:chartDataset
		chartType	= "Bar"
	>
		<jsp:text>
			select TABLESPACE_NAME,
					SUM(INITIAL_AUTO) AS KEI
			from GF02
		</jsp:text>
		<og:where>
			<og:and value = "FGJ             in  ('0','1')"              />
			<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"       />
			<og:and value = "TBLSYU          like '{@TBLSYU}%'"          />
			<og:and value = "TABLESPACE_NAME like '{@TABLESPACE_NAME}%'" />
		</og:where>
		<jsp:text>
			group by TABLESPACE_NAME
			order by TABLESPACE_NAME
		</jsp:text>
	</og:chartDataset>
</og:chartCreate>
</td></tr>
</table>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select SYSTEM_ID,TABLESPACE_NAME,TABLE_NAME,
				SUM(INITIAL_AUTO) AS KEI
		from GF02
	</jsp:text>
	<og:where>
		<og:and value = "FGJ             in  ('0','1')"              />
		<og:and value = "TBLSYU          like '{@TBLSYU}%'"          />
		<og:and value = "TABLESPACE_NAME like '{@TABLESPACE_NAME}%'" />
	</og:where>
	<jsp:text>
		group by SYSTEM_ID,cube(TABLESPACE_NAME,TABLE_NAME)
		order by SYSTEM_ID,TABLESPACE_NAME,TABLE_NAME
	</jsp:text>
</og:query>

<og:view
	viewFormType = "HTMLCrossTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}"
/>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
