<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2050"
	title	= "定義ファイル取込"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
>
	5.5.1.6 (2012/04/16) Takahashi Masakazu GF80変更に伴う修正(LUK,IXH,IXI,IXJ,IXK)
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TABLE_NAME,CLM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select CASE WHEN TBLSYU = '3' THEN '1' ELSE '0' END AS WRITABLE,
				TABLE_NAME,NAME_JA,SEQNO,CLM_NAME,CLM,'' as DTYPE,CLS_NAME,
				PHY_LENGTH,USE_LENGTH,UK,LUK,IXA,IXB,IXC,IXD,IXE,IXF,IXG,IXH,IXI,IXJ,IXK,NOT_NULL,C_KEY,F_KEY,
				RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,KBCLM,BIKO,COMMENTS,SYSTEM_ID,FGJ,UNIQ
		from GF80
	</jsp:text>
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"     />
		<og:and value = "TBLSYU      = '{@TBLSYU}'"         />
		<og:and value = "TABLE_NAME  like '{@TABLE_NAME}%'" />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "CLM_NAME    like '{@CLM_NAME}%'"   />
		<og:and value = "CLS_NAME    = '{@CLS_NAME}'"       />
		<og:and value = "RENDERER    = '{@RENDERER}'"       />
		<og:and value = "EDITOR      = '{@EDITOR}'"         />
		<og:and value = "DBTYPE      = '{@DBTYPE}'"         />
		<og:and value = "NOT_NULL    = '{@NOT_NULL}'"       />
		<og:and value = "USE_LENGTH  = '{@USE_LENGTH}'"     />
		<og:and value = "KBCLM       = '{@KBCLM}'"          />
		<og:and value = "BIKO        like '{@BIKO}%'"       />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,TBLSYU,TABLE_NAME,SEQNO" />
</og:query>

<og:tableFilter classId="DTYPE" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />
	<og:submit  value="fileIn" command="VIEW" lbl="File In" accesskey="I" 
		onClick="ogOpen( '{@SYS.JSP}/common/filePopup.jsp?callBack={@GUI.KEY}/fileIn.jsp',event,null,'width=250px,height=50px,resizable=no',false);" />
	<fieldset style="display:inline;">
		<legend><strong><og:text>{@LBL.DeleteAll}</og:text></strong></legend>
		<og:column name="SYSTEM_ID" value="{@SYSTEM_ID}" />
		<og:submit  value="deleteAll" lbl="DeleteAll" command="NEW" />
	</fieldset>
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<og:hidden name="SYSTEM_ID"   value="{@SYSTEM_ID}"   />
<og:hidden name="maxRowCount" value="{@maxRowCount}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
