<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2080"
	title	= "オブジェクト一覧"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,OBJ_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" maxRowCount="{@maxRowCount}" quotCheck="false" >
  <jsp:text>
	select SYSTEM_ID,TBLSYU,OBJ_TYPE,OBJ_NAME,NAME_JA,STTS,UNIQ,FGJ
	from GF82
  </jsp:text>
	<og:where>
		<og:and value="SYSTEM_ID	=    '{@SYSTEM_ID}'"	/>
		<og:and value="TBLSYU		=    '{@TBLSYU}'"		/>
		<og:and value="OBJ_NAME		like '{@OBJ_NAME}%'"	/>
		<og:and value="OBJ_TYPE		in ( {@OBJ_TYPE} )" multi="true" />
		<og:and value="STTS			=	 '{@STATUS}'"		/>
	</og:where>
	<og:appear startKey="order by" value="{@ORDER_BY}"
				defaultVal="OBJ_NAME,OBJ_TYPE" />
</og:query>

<og:viewLink command="{@command}">
	<og:link gamenId="GE1004" column="OBJ_NAME" href="viewObject.jsp" target="SUB_WIND"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,{@SYSTEM_ID},[OBJ_TYPE],[OBJ_NAME],{@DBID}" />
	<og:link gamenId="GE1004" column="STTS" href="viewObject.jsp" target="SUB_WIND" onLink="INVALID" markList="[STTS]"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,{@SYSTEM_ID},ERRORS,[OBJ_NAME],{@DBID}" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GF82" /></strong></legend>
		<og:column  name="DBID"		size="5" td="no" />
		<og:column  name="TBLSYU" defaultVal="2" addNoValue="false" td="no" />
		<og:select name="OBJ_TYPE2" lbl="OBJ_TYPE">
			<og:option lbl=""			value=""			/>
			<og:option lbl="sequence"	value="SEQUENCE"	/>
			<og:option lbl="trigger"	value="TRIGGER"		/>
			<og:option lbl="synonym"	value="SYNONYM"		/>
			<og:option lbl="function"	value="FUNCTION"	/>
			<og:option lbl="package"	value="PACKAGE"		/>
			<og:option lbl="pkg body"	value="PACKAGE BODY"/>
			<og:option lbl="procedure"	value="PROCEDURE"	/>
			<og:option lbl="type"		value="TYPE"		/>
			<og:option lbl="type body"	value="TYPE BODY"	/>
		</og:select>
		<og:submit  value="directGF82" lbl="DIRECT" command="INSERT" />
	</fieldset>
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ,FGJ"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
