<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2130"
	title	= "テーブル一覧表"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TBLSYU,TABLE_NAME"
/>

<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.TABLE_NAME,B.NAME_JA AS T_NAME,A.SEQNO,A.CLM,A.NAME_JA,
				A.FGCOM,
				(CASE A.CLS_NAME WHEN 'VARCHAR2' THEN 'X(' ELSE 'S(' END ) || A.USE_LENGTH || ')' as CLS_NAME
		from GF05 A inner join GF02 B
		on  ( A.SYSTEM_ID  = B.SYSTEM_ID
		and   A.TABLE_NAME = B.TABLE_NAME
		and   A.TBLSYU     = B.TBLSYU )
		where A.FGJ = '1'
		and   B.FGJ = '1'
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.FGCOM        =   '{@FGCOM}'"         />
		<og:and value = "A.SYSTEM_ID    =   '{@SYSTEM_ID}'"     />
		<og:and value = "A.TBLSYU       =   '{@TBLSYU}'"        />
		<og:and value = "A.TABLE_NAME   like '{@TABLE_NAME}%'"  />
	</og:where>
	<jsp:text>
		order by A.TABLE_NAME,A.SEQNO
	</jsp:text>
</og:query>

<og:equals val1="{@USE_LBL}" val2="true" >
	<og:tableFilter classId="LABEL" keys="CLM,LBL" vals="TABLE_NAME,T_NAME" />
	<og:tableFilter classId="LABEL" keys="CLM,LBL" vals="CLM,NAME_JA" />
</og:equals>

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}"
	writable   = "false"
	numberType = "delete"
	useCheckControl = "false"
	useScrollBar    = "false"
	rowspan    = "1"
	headerSkipCount = "0"
>
	<og:thead rowspan="1">
		<tr><td></td><td></td><td></td></tr>
	</og:thead>
	<og:tbody usableKey="SEQNO" usableList="1" rowspan="3">
		<tr><td style="background-color: Beige;" colspan="3">{@LBL.SPACE}</td></tr>
		<tr class="row_h"><td>[TABLE_NAME]</td><td colspan="2">[T_NAME]</td></tr>
	</og:tbody>
	<og:tbody rowspan="1" >
		<tr><td>[NAME_JA]</td><td>[CLM]</td><td>[CLS_NAME]</td></tr>
	</og:tbody>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
