<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:仕様書DB"
	pgid	= "GF2200"
	title	= "画面項目定義テーブル登録"
	date	= "2009/07/08"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- エラー時に戻るボタンを表示します。-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck を含め、すべて自動で処理されます。-->
<og:columnCheck command="{@command}" />

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<!-- TableExistTag は、command="ENTRY" のときのみ有効です。-->
<og:dataCheck command="{@command}">
	<jsp:text>
		select count(*) from GF91
		where SYSTEM_ID=[SYSTEM_ID] AND PGID=[PGID] AND TABLE_NAME=[TABLE_NAME]
	</jsp:text>
</og:dataCheck>

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" >
	<og:tableUpdateParam
		sqlType  = "{@sqlType}"
		table  = "GF91"
		where  = "UNIQ=[UNIQ]"
		omitNames   = "NMPG"
		constKeys   = "FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD"
		constVals   = "1,{@USER.YMDH},{@USER.YMDH},{@USER.ID},{@USER.ID},{@GUI.KEY}"

	/>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
