<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9110"
	title	= "標準(タグ)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		select CLM,LANG,KBSAKU||':'||LANG	AS	KBSAKU,SYSTEM_ID,
				NAME_JA,LABEL_NAME,COMMENTS,FGJ
		from GF41
	</jsp:text>
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"     />
		<og:and value = "LANG        =  '{@LANG}'"          />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}%'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor column="LANG"      must="true" />
<og:columnEditor column="CLM"       must="true" size="20" />
<!-- 動的カラムの設定例 -->
<!-- {@xxx}と書くと同じ行のxxxのカラムの値が取得される。 -->
<!-- 読み込み後に1度changeイベントが発行される。 -->
<og:columnEditor columns="KBSAKU"  editor="DBMENU" eventColumn="LANG" addNoValue="false" >
	<jsp:text>
		SELECT A.CODE,B.LNAME FROM GEA04 A,GEA08 B
		 WHERE A.CLM||'.'||A.CODE = B.CLM 
		 AND A.SYSTEM_ID = B.SYSTEM_ID 
		 AND A.CLM = 'KBSAKU' 
		 AND B.LANG = '{@LANG}'
		 AND B.FGJ = '1' 
		 AND B.SYSTEM_ID = '**' 
		 AND A.FGJ='1'
	</jsp:text>
</og:columnEditor>
<og:columnEditor columns="COMMENTS" eventColumn="KBSAKU" addNoValue="false"
	parameter="SELECT '{@KBSAKU}' as KBSAKU from GEA10" />
<og:columnEditor columns="NAME_JA" eventColumn="CLM" addNoValue="false"
	parameter="SELECT NAME_JA as VALUE from GF41 where CLM='{@CLM}' and LANG='{@LANG}'" />
<og:columnEditor columns="LABEL_NAME" eventColumn="CLM" addNoValue="false"
	parameter="SELECT LABEL_NAME as LABEL_NAME from GF41 where CLM='{@CLM}' and LANG='{@LANG}'" />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="update"   command="COPY"   lbl="COPY"    accesskey="C"
			keys="noWritable" vals='"NAME_JA,LABEL_NAME"' />
	<og:submit  value="update"   command="MODIFY" lbl="MODIFY"  accesskey="M" 
			keys="noWritable" vals='"CLM,NAME_JA,LABEL_NAME"' />
	<og:submit  value="update"   command="DELETE" lbl="DELETE"  accesskey="D" 
			keys="columnWritable" vals="null" />
	<og:submit  gamenId="GF9110" value="index" dbkeys="SYSTEM_ID,LANG,CLM" command="NEW" lbl="GF9100" target="CONTENTS" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
