/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package gf;

import org.opengion.fukurou.business.BizLogic_TABLE;

/**
 * 一覧登録:標準(Java) (GF9140) の 業務ロジックです。
 * 
 * 画面で入力された情報を元にGF41に登録を行います。
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 * @og.group 業務ロジック
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class GF9140A extends BizLogic_TABLE {

	/**
	 * メインカーソルの各行(変更区分の各処理の前)で呼ばれるチェックロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean befchk( final int row ) {
//		String cnt = "select count(*) CNT from GF41 where clm=[CLM]";
//		sql( cnt );
		return true;
	}

  	/**
	 * メインカーソルの各行(変更区分="A")で呼ばれるチェックロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean inschk( final int row ) {
//		if( vari( "CNT" ) > 0 ) {
//			error( NG, "ERR0014", "[CLM]", "{#GF41}" );
//		}
		// 存在チェック(データが存在しない場合のみOK)を行っています。
		exist( "false", "GF41", "CLM,LANG", "[CLM],[LANG]", "FGJ", "'1'" );
		return true;
	}

  	/**
	 * メインカーソルの各行(変更区分="C")で呼ばれるチェックロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean modchk( final int row ) {
//		if( vari( "CNT" ) == 0 ) {
//			error( NG, "ERR0015", "[CLM]", "{#GF41}" );
//		}
		// 存在チェック(データが存在する場合のみOK)を行っています。
		exist( "true", "GF41", "CLM,LANG", "[CLM],[LANG]", "FGJ", "'1'" );

		return true;
	}

  	/**
	 * メインカーソルの各行(変更区分="D")で呼ばれるチェックロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean delchk( final int row ) {
		return modchk( row );
	}

  	/**
	 * メインカーソルの各行(変更区分="A")で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean insert( final int row ) {
//		String ins = "insert into GF41("
//			+ "system_id, lang, clm, name_ja, label_name, kbsaku, fgj "
//			+ ", dyset, usrset, pgset, pgpset, dyupd, usrupd, pgupd, pgpupd"
//			+ ") values ("
//			+ "[SYSTEM_ID], [LANG], [CLM], [NAME_JA], [LABEL_NAME], [KBSAKU], '1' "
//			+ ", '{@CON.YMDH}', '{@CON.USERID}', '{@CON.PGID}', '{@CON.PGPID}', '{@CON.YMDH}', '{@CON.USERID}', '{@CON.PGID}', '{@CON.PGPID}'"
//			+ ")";
//		sql( ins );
		// パラメーターを与えて、サブルーチンを呼び出します。
		boolean rtn = call( "gf.GF0001", "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME,KBSAKU", "[SYSTEM_ID],[LANG],[CLM],[NAME_JA],[LABEL_NAME],[KBSAKU]" );
		if( !rtn ) { return false; }

		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="C")で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean modify( final int row ) {
//		String upd = "update GF41 set "
//			+ "name_ja = [NAME_JA] "
//			+ ",label_name = [LABEL_NAME] "
//			+ ",kbsaku = [KBSAKU] "
//			+ ",system_id = [SYSTEM_ID] "
//			+ ",lang = [LANG] "
//			+ ",dyupd = '{@CON.YMDH}' "
//			+ ",usrupd = '{@CON.USERID}' "
//			+ ",pgupd = '{@CON.PGID}' "
//			+ ",pgpupd = '{@CON.PGPID}' "
//			+ "where system_id = [SYSTEM_ID] "
//			+ "and clm = [CLM] "
//			+ "and lang = [LANG] ";
//		sql( upd );
		// パラメーターを与えて、サブルーチンを呼び出します。
		boolean rtn = call( "gf.GF0001", "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME,KBSAKU", "[SYSTEM_ID],[LANG],[CLM],[NAME_JA],[LABEL_NAME],[KBSAKU]" );
		if( !rtn ) { return false; }

		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="D")で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean delete( final int row ) {
//		String del = "delete from GF41 " + "where clm=[CLM]";
		String del = "delete from GF41 "
				+ "where system_id = [SYSTEM_ID] "
				+ "and clm = [CLM] "
				+ "and KBSAKU = [KBSAKU] "
				+ "and lang = [LANG] ";

		sql( del );

		return true;
	}
}
