/**************************************************************************/
/* GF71 ( 画面関連状態テーブル )                                          */
/*                                                                        */
/* Created : 2012/07/28 16:35:01                                          */
/**************************************************************************/
CREATE TABLE GF71 (
   SYSTEM_ID   VARCHAR2(10)                 NOT NULL      /* 10  システムID       */
 , ADDRESS     VARCHAR2(256)                              /* 20  アドレス         */
 , PRE_FIX     VARCHAR2(10)                 NOT NULL      /* 30  名前空間         */
 , FILENAME    VARCHAR2(60)                               /* 40  ファイル名       */
 , FILEPATH    VARCHAR2(256)                              /* 50  ファイルパス     */
 , MODIFIED    VARCHAR2(14)                               /* 60  最終更新日       */
 , TAGNAME     VARCHAR2(30)                               /* 70  タグ名称         */
 , TO_GAMENID  VARCHAR2(30)                               /* 80  先画面ID         */
 , HREF        VARCHAR2(256)                              /* 90  リンク先URL      */
 , TARGET      VARCHAR2(10)                               /* 100 ターゲット       */
 , CLM         VARCHAR2(30)                               /* 110 項目             */
 , P_KEYS      VARCHAR2(500)                              /* 120 引数キー         */
 , P_VALS      VARCHAR2(500)                              /* 130 引数値           */
 , USEGAMENID  VARCHAR2(10)                               /* 140 画面使用         */
 , USEREDIRECT VARCHAR2(10)                               /* 150 リダイレクト使用 */
 , TEXT_DATA   CLOB                                       /* 160 テキスト         */
 , FGOMIT      VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 170 除外フラグ       */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 180 ユニークキー     */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 190 状態フラグ       */
 , DYSET       VARCHAR2(14)                               /* 200 登録日時         */
 , PGSET       VARCHAR2(10)                               /* 210 作成PG           */
 , PGPSET      VARCHAR2(10)                               /* 220 作成親PG         */
 , USRSET      VARCHAR2(10)                               /* 230 作成社員         */
 , DYUPD       VARCHAR2(14)                               /* 240 更新日時         */
 , PGUPD       VARCHAR2(10)                               /* 250 更新PG           */
 , PGPUPD      VARCHAR2(10)                               /* 260 更新親PG         */
 , USRUPD      VARCHAR2(10)                               /* 270 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 576K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF71S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF71T00 
BEFORE INSERT ON GF71
FOR EACH ROW 
BEGIN 
SELECT GF71S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

