/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.calendar;

import org.opengion.hayabusa.resource.CalendarQuery;
import org.opengion.hayabusa.common.HybsSystemException;

/**
 * カレンダＤＢ(WI008)の検索QUERYを定義したクラスです。
 *
 * QUERY は、このオブジェクトを、toString() して求めることとします。
 * 本来は、これらのクラスの共通インターフェースを作成して、getQuery() などのメソッドを
 * 介して取得すべきですが、Object の共通クラスを利用することとします。
 *
 * @og.rev 3.6.0.0 (2004/09/17) 新規作成
 * @og.group リソース管理
 *
 * @version  0.9.0  2000/10/17
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public final class CalendarQuery_WI008 implements CalendarQuery {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	/** カレンダＤＢの読み込みのクエリー(WI008) {@value} */
	public static final String QUERY =
				"select YMD,HOL"
				+ " from WI008 where CDKT=?"
				+ " order by YMD" ;

	/**
	 * ４つの引数を受け取り、整合性チェックを行います。
	 * 引数は、各クラスによって使用するカラム名(意味)が異なります。
	 * また、すべての引数をチェックするのではなく、クラス毎に、チェックする
	 * カラムの数は、異なります。
	 * 引数が正しくない場合は、HybsSystemException を発行します。
	 *
	 * @param	arg1  	データベース検索時の第１引数(CDKT:工程)
	 * @param	arg2  	データベース検索時の第２引数(未使用)
	 * @param	arg3  	データベース検索時の第３引数(未使用)
	 * @param	arg4  	データベース検索時の第４引数(未使用)
	 *
	 * @return	入力パラメータに応じた配列文字列(cdkt)
	 * @throws HybsSystemException
	 */
	public String[] checkArgment( final String arg1,final String arg2,final String arg3,final String arg4 ) {
		String cdkt = arg1;

		if( cdkt == null || cdkt.length() == 0 ) {
			String errMsg = "CalendarQuery_WI008 クラスは、唯一の引数 "
						+ "CDKT(工程)を指定して、初期化下さい。" ;
			throw new HybsSystemException( errMsg );
		}
		return new String[] { cdkt } ;
	}

	/**
	 * データベース検索の為の Select 文を返します。
	 * 引数リストとともに、使用します。
	 *
	 * @return データベース検索の為の Select 文
	 *
	 */
	public String getQuery() {
		return QUERY;
	}

	/**
	 * データベースの持ち方を指定します。
	 * 持ち方がフラット(横持ち=1～31の日付をカラムで持つ)の場合、trueを返します。
	 * 縦持ち(日付単位で、行情報として持つ)場合は、false です。
	 *
	 * @return DBの持ち方がフラット(横持ち=1～31の日付をカラムで持つ)の場合、true
	 *
	 */
	public boolean isFlatTable() {
		return false;
	}
}
