/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.model.ArrayDataModel;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.ResourceManager;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;
import org.opengion.hayabusa.taglib.TransactionTag;

public class DirectTableInsertTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final String TAB_SEPARATOR = "\t";
    private String dbid = null;
    private String separator = "\t";
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String encode = HybsSystem.sys("FILE_ENCODE");
    private String displayMsg = "MSG0040";
    private String[] columns = null;
    private String[] clmKeys = null;
    private String sql = null;
    private int commitBatch = 0;
    private boolean useColumnCheck = false;
    private boolean useColumnAdjust = false;
    private String[] nullCheck = null;
    private long dyStart = 0L;

    @Override
    public int doStartTag() {
        this.dyStart = System.currentTimeMillis();
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.sql = this.getBodyString();
        if (this.sql == null || this.sql.length() == 0) {
            String string = "BODY \u90e8\u306e\u767b\u9332\u7528 Insert/Update\u6587\u306f\u3001\u5fc5\u9808\u3067\u3059\u3002";
            throw new HybsSystemException(string);
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        BufferedReader bufferedReader = this.getBufferedReader();
        int n = this.create(bufferedReader);
        Closer.ioClose((Closeable)bufferedReader);
        if (this.displayMsg != null && this.displayMsg.length() > 0) {
            String string = n + this.getResource().getLabel(this.displayMsg);
            this.jspPrint(string + HybsSystem.BR);
        }
        long l = System.currentTimeMillis() - this.dyStart;
        this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        GUIInfo gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (gUIInfo != null) {
            gUIInfo.addWriteCount(n, l, this.sql);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.dbid = null;
        this.separator = TAB_SEPARATOR;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.encode = HybsSystem.sys("FILE_ENCODE");
        this.displayMsg = "MSG0040";
        this.columns = null;
        this.useColumnCheck = false;
        this.useColumnAdjust = false;
        this.nullCheck = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int create(BufferedReader bufferedReader) {
        Object object;
        String[] stringArray = this.readName(bufferedReader);
        int n = stringArray.length;
        ArrayDataModel arrayDataModel = new ArrayDataModel(stringArray);
        Formatter formatter = new Formatter((DataModel)arrayDataModel);
        formatter.setFormat(this.sql.trim());
        this.sql = formatter.getQueryFormatString();
        int[] nArray = formatter.getClmNos();
        int n2 = nArray.length;
        this.clmKeys = formatter.getClmKeys();
        CheckColumnData checkColumnData = new CheckColumnData(nArray, this.clmKeys, this.getResource());
        ArrayDataModel arrayDataModel2 = new ArrayDataModel(stringArray);
        int[] nArray2 = arrayDataModel2.getColumnNos(this.nullCheck);
        int n3 = nArray2.length;
        int n4 = 0;
        int n5 = 0;
        char c = this.separator.charAt(0);
        boolean bl = true;
        Object object2 = null;
        PreparedStatement preparedStatement = null;
        String[] stringArray2 = null;
        try {
            TransactionTag transactionTag = (TransactionTag)DirectTableInsertTag.findAncestorWithClass((Tag)this, TransactionTag.class);
            object2 = transactionTag == null ? new TransactionReal(this.getApplicationInfo()) : transactionTag.getTransaction();
            object = object2.getConnection(this.dbid);
            preparedStatement = object.prepareStatement(this.sql);
            while (true) {
                block15: {
                    int n6;
                    String string;
                    String string2;
                    block17: {
                        StringBuilder stringBuilder;
                        int n7;
                        block18: {
                            block16: {
                                if ((string2 = bufferedReader.readLine()) == null) break block16;
                                if (string2.length() == 0 || string2.charAt(0) == '#') continue;
                                n7 = StringUtil.countChar((String)string2, (char)'\"');
                                if (n7 % 2 == 0) break block17;
                                string = null;
                                stringBuilder = new StringBuilder(string2);
                                break block18;
                            }
                            object2.commit();
                            n5 = n4;
                            bl = false;
                            Closer.stmtClose((Statement)preparedStatement);
                            if (object2 == null) return n5;
                            object2.close(bl);
                            return n5;
                        }
                        while (n7 % 2 != 0 && (string = bufferedReader.readLine()) != null) {
                            if (string2.length() == 0 || string2.charAt(0) == '#') continue;
                            stringBuilder.append(HybsSystem.CR).append(string);
                            n7 += StringUtil.countChar((String)string, (char)'\"');
                        }
                        string2 = stringBuilder.toString();
                    }
                    stringArray2 = StringUtil.csv2Array((String)string2, (char)c, (int)n);
                    if (this.useColumnAdjust) {
                        stringArray2 = checkColumnData.adjustData(stringArray2);
                    }
                    if (this.useColumnCheck && !(string = checkColumnData.checkData(n4, stringArray2)).isOK()) {
                        object2.rollback();
                        this.jspPrint(TaglibUtil.makeHTMLErrorTable((ErrorMessage)string, this.getResource()));
                        int n8 = n5;
                        Closer.stmtClose((Statement)preparedStatement);
                        if (object2 == null) return n8;
                        object2.close(bl);
                        return n8;
                    }
                    if (n3 <= 0) break block15;
                    string = new ErrorMessage("Null Check Columns Error!");
                    for (n6 = 0; n6 < n3; ++n6) {
                        int n9 = nArray2[n6];
                        if (stringArray2[n9] != null && stringArray2[n9].length() != 0) continue;
                        String string3 = this.getResource().getLabel(this.nullCheck[n6]);
                        string.addMessage(n4 + 1, 2, "ERR0012", new String[]{string3});
                    }
                    if (string.isOK()) break block15;
                    object2.rollback();
                    this.jspPrint(TaglibUtil.makeHTMLErrorTable((ErrorMessage)string, this.getResource()));
                    n6 = n5;
                    Closer.stmtClose((Statement)preparedStatement);
                    if (object2 == null) return n6;
                    object2.close(bl);
                    return n6;
                }
                for (int i = 0; i < n2; ++i) {
                    String string = stringArray2[nArray[i]];
                    if (string != null && string.startsWith("'0")) {
                        string = string.substring(1);
                    }
                    preparedStatement.setString(i + 1, string);
                }
                preparedStatement.execute();
                if (this.commitBatch > 0 && n4 % this.commitBatch == 0) {
                    object2.commit();
                    n5 = n4;
                }
                ++n4;
            }
        }
        catch (IOException iOException) {
            try {
                object = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + bufferedReader.toString() + "]" + " \u884c\u756a\u53f7=[" + n4 + "]" + " \u767b\u9332\u4ef6\u6570=[" + n5 + "]";
                throw new HybsSystemException((String)object, iOException);
                catch (SQLException sQLException) {
                    object = "sql=[" + this.sql + "]" + HybsSystem.CR + "names=[" + StringUtil.array2csv((String[])stringArray) + "]" + HybsSystem.CR + "vals =[" + StringUtil.array2csv(stringArray2) + "]" + HybsSystem.CR + " \u884c\u756a\u53f7=[" + n4 + "]" + " \u767b\u9332\u4ef6\u6570=[" + n5 + "]" + HybsSystem.CR + " errorCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + HybsSystem.CR;
                    throw new HybsSystemException((String)object, sQLException);
                }
            }
            catch (Throwable throwable) {
                Closer.stmtClose(preparedStatement);
                if (object2 == null) throw throwable;
                object2.close(bl);
                throw throwable;
            }
        }
    }

    private String[] readName(BufferedReader bufferedReader) {
        String string;
        if (this.columns != null && this.columns.length > 0) {
            return this.columns;
        }
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0) continue;
                if (string.charAt(0) == '#') {
                    if (string.length() < 5 || !"#NAME".equalsIgnoreCase(string.substring(0, 5))) continue;
                    String[] stringArray = StringUtil.csv2Array((String)string, (char)TAB_SEPARATOR.charAt(0));
                    stringArray[0] = "ROW_NO";
                    return stringArray;
                }
                String string2 = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002" + HybsSystem.CR + " LINE=" + string;
                throw new HybsSystemException(string2);
            }
        }
        catch (IOException iOException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + bufferedReader.toString() + "]";
            throw new HybsSystemException(string3, iOException);
        }
        string = "#NAME \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
        throw new HybsSystemException(string);
    }

    private BufferedReader getBufferedReader() {
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        String string = HybsSystem.url2dir(this.fileURL);
        File file = new File(StringUtil.urlAppend((String)string, (String)this.filename));
        BufferedReader bufferedReader = FileUtil.getBufferedReader((File)file, (String)this.encode);
        return bufferedReader;
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setDisplayMsg(String string) {
        if (string != null) {
            this.displayMsg = string;
        }
    }

    public void setColumns(String string) {
        this.columns = StringUtil.csv2Array((String)StringUtil.nval((String)this.getRequestParameter(string), null), (char)',');
    }

    public void setCommitBatch(String string) {
        this.commitBatch = StringUtil.nval((String)this.getRequestParameter(string), (int)this.commitBatch);
    }

    public void setUseColumnCheck(String string) {
        this.useColumnCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useColumnCheck);
    }

    public void setUseColumnAdjust(String string) {
        this.useColumnAdjust = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useColumnAdjust);
    }

    public void setNullCheck(String string) {
        this.nullCheck = StringUtil.csv2Array((String)this.getRequestParameter(string));
        if (this.nullCheck.length == 0) {
            this.nullCheck = null;
        }
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("separator", (Object)this.separator).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("encode", (Object)this.encode).println("displayMsg", (Object)this.displayMsg).println("columns", (Object[])this.columns).println("clmKeys", (Object[])this.clmKeys).println("sql", (Object)this.sql).println("commitBatch", (Object)this.commitBatch).println("useColumnCheck", (Object)this.useColumnCheck).println("useColumnAdjust", (Object)this.useColumnAdjust).println("nullCheck", (Object[])this.nullCheck).println("dyStart", (Object)this.dyStart).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    static class CheckColumnData {
        private final DBColumn[] dbClm;
        private final int[] clmChkNo;
        private final int len;
        private final ErrorMessage errMsg = new ErrorMessage("Check Columns Error!");

        CheckColumnData(int[] nArray, String[] stringArray, ResourceManager resourceManager) {
            if (nArray == null || nArray.length == 0 || stringArray == null || stringArray.length == 0) {
                this.dbClm = null;
                this.clmChkNo = null;
                this.len = 0;
            } else {
                this.clmChkNo = nArray;
                this.len = nArray.length;
                this.dbClm = new DBColumn[this.len];
                for (int i = 0; i < this.len; ++i) {
                    this.dbClm[i] = resourceManager.makeDBColumn(stringArray[i]);
                }
            }
        }

        String[] adjustData(String[] stringArray) {
            if (this.len == 0) {
                return stringArray;
            }
            String[] stringArray2 = new String[this.len];
            for (int i = 0; i < this.len; ++i) {
                String string = stringArray[this.clmChkNo[i]];
                stringArray2[i] = this.dbClm[i].valueSet(string);
            }
            return stringArray2;
        }

        ErrorMessage checkData(int n, String[] stringArray) {
            for (int i = 0; i < this.len; ++i) {
                String string = stringArray[this.clmChkNo[i]];
                this.errMsg.append(n + 1, this.dbClm[i].valueCheck(string));
            }
            return this.errMsg;
        }
    }
}

