/**************************************************************************/
/* GF80 ( DB定義書マスタテーブル )                                        */
/*                                                                        */
/* Created : 2012/07/28 16:35:01                                          */
/**************************************************************************/
CREATE TABLE GF80 (
   SYSTEM_ID    VARCHAR2(10)                  NOT NULL      /* 10  システムID   */
 , TBLSYU       VARCHAR2(1)                   NOT NULL      /* 20  テーブル種別 */
 , TABLE_NAME   VARCHAR2(50)                  NOT NULL      /* 30  テーブル名   */
 , NAME_JA      VARCHAR2(200)                               /* 40  名称         */
 , SEQNO        NUMBER(7)         DEFAULT 0   NOT NULL      /* 50  表示順       */
 , CLM_NAME     VARCHAR2(120)                               /* 60  項目名(漢字) */
 , CLM          VARCHAR2(30)                  NOT NULL      /* 70  項目         */
 , CLS_NAME     VARCHAR2(10)                  NOT NULL      /* 80  DBクラス     */
 , PHY_LENGTH   VARCHAR2(10)                                /* 90  物理桁数     */
 , USE_LENGTH   VARCHAR2(9)       DEFAULT '0'               /* 100 使用桁数     */
 , UK           VARCHAR2(2)                                 /* 110 UK           */
 , LUK          VARCHAR2(2)                                 /* 120 LUK          */
 , IXA          VARCHAR2(2)                                 /* 130 IXA          */
 , IXB          VARCHAR2(2)                                 /* 140 IXB          */
 , IXC          VARCHAR2(2)                                 /* 150 IXC          */
 , IXD          VARCHAR2(2)                                 /* 160 IXD          */
 , IXE          VARCHAR2(2)                                 /* 170 IXE          */
 , IXF          VARCHAR2(2)                                 /* 180 IXF          */
 , IXG          VARCHAR2(2)                                 /* 190 IXG          */
 , IXH          VARCHAR2(2)                                 /* 200 IXH          */
 , IXI          VARCHAR2(2)                                 /* 210 IXI          */
 , IXJ          VARCHAR2(2)                                 /* 220 IXJ          */
 , IXK          VARCHAR2(2)                                 /* 230 IXK          */
 , NOT_NULL     VARCHAR2(1)                                 /* 240 NOT NULL     */
 , C_KEY        VARCHAR2(1)                                 /* 250 C_KEY        */
 , F_KEY        VARCHAR2(1)                                 /* 260 F_KEY        */
 , RENDERER     VARCHAR2(10)                                /* 270 表示種別     */
 , EDITOR       VARCHAR2(10)                                /* 280 編集種別     */
 , DBTYPE       VARCHAR2(10)                                /* 290 文字種別     */
 , DATA_DEFAULT VARCHAR2(30)                                /* 300 初期値       */
 , KBCLM        VARCHAR2(1)                                 /* 310 カラム区分   */
 , BIKO         VARCHAR2(2000)                              /* 320 備考         */
 , CDKH         VARCHAR2(1)                                 /* 330 改廃コード   */
 , COMMENTS     VARCHAR2(500)                               /* 340 コメント     */
 , UNIQ         NUMBER(9)         DEFAULT 0   NOT NULL      /* 350 ユニークキー */
 , FGJ          VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 360 状態フラグ   */
 , DYSET        VARCHAR2(14)                                /* 370 登録日時     */
 , PGSET        VARCHAR2(10)                                /* 380 作成PG       */
 , PGPSET       VARCHAR2(10)                                /* 390 作成親PG     */
 , USRSET       VARCHAR2(10)                                /* 400 作成社員     */
 , DYUPD        VARCHAR2(14)                                /* 410 更新日時     */
 , PGUPD        VARCHAR2(10)                                /* 420 更新PG       */
 , PGPUPD       VARCHAR2(10)                                /* 430 更新親PG     */
 , USRUPD       VARCHAR2(10)                                /* 440 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 3072K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF80S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF80T00 
BEFORE INSERT ON GF80
FOR EACH ROW 
BEGIN 
SELECT GF80S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

